/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.CFGraph;
import org.bdware.analysis.InsnPrinter;
import org.bdware.analysis.OpInfo;
import org.bdware.analysis.taint.TaintBB;
import org.bdware.analysis.taint.TaintCFG;
import org.objectweb.asm.tree.AbstractInsnNode;

public class FrontCF {
    String methodName;
    public List<FrontBB> blocks = new ArrayList<FrontBB>();
    public List<FrontEdge> edges = new ArrayList<FrontEdge>();
    public String ret;
    public String finalRet;
    transient InsnPrinter printer;
    transient ArrayPs ps;

    public FrontCF(CFGraph graph) {
        try {
            this.ps = new ArrayPs();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.printer = new InsnPrinter(262144, this.ps);
        this.printer.setLabelOrder(graph.getLabelOrder());
    }

    public void addBB(BasicBlock bb, String original, List<Integer> ids, TaintCFG cfg) {
        FrontBB fb = new FrontBB();
        this.blocks.add(fb);
        fb.name = "B" + bb.blockID;
        List<AbstractInsnNode> insnList = bb.getInsn();
        fb.type = "Continuous";
        fb.original = original;
        TaintBB b = (TaintBB)bb;
        fb.result = b.getResult();
        if (ids == null) {
            fb.blockDep = "";
        } else {
            StringBuilder sb = new StringBuilder();
            for (Integer id : ids) {
                TaintBB tb = (TaintBB)cfg.getBasicBlockAt(id);
                sb.append(tb.preResult.frame.getStack(0).toReadableTaint());
            }
            fb.blockDep = sb.toString();
        }
        if (insnList != null && insnList.size() > 0) {
            OpInfo info;
            AbstractInsnNode lastStmt = insnList.get(insnList.size() - 1);
            if (lastStmt.getOpcode() >= 0 && ((info = OpInfo.ops[lastStmt.getOpcode()]).canBranch() || info.canSwitch())) {
                fb.type = "Branch";
            }
            fb.stmts = new ArrayList<String>();
            this.ps.content = fb.stmts;
            for (AbstractInsnNode node : insnList) {
                node.accept(this.printer);
            }
        }
    }

    public void addEdge(BasicBlock bb, BasicBlock suc) {
        FrontEdge edge = new FrontEdge();
        List<AbstractInsnNode> insnList = bb.getInsn();
        edge.label = new EdgeLabel();
        edge.label.label = "e";
        AbstractInsnNode lastStmt = insnList.get(insnList.size() - 1);
        boolean ignore = false;
        if (lastStmt.getOpcode() >= 0) {
            OpInfo info = OpInfo.ops[lastStmt.getOpcode()];
            if (info.canBranch() && info.toString().startsWith("if")) {
                edge.label.label = suc.blockID == bb.blockID + 1 ? "false" : "true";
            }
            if (info.canThrow() && info.toString().startsWith("invoke") && suc.blockID != bb.blockID + 1) {
                ignore = true;
            }
        }
        edge.from = "B" + bb.blockID;
        edge.to = "B" + suc.blockID;
        if (!ignore) {
            this.edges.add(edge);
        }
    }

    public static class FrontEdge {
        String from;
        String to;
        EdgeLabel label;
    }

    public static class EdgeLabel {
        String label;
    }

    public static class FrontBB {
        String type;
        String name;
        List<String> stmts;
        String original;
        String result;
        String blockDep;
    }

    static class ArrayPs
    extends PrintStream {
        List<String> content;

        public ArrayPs() throws FileNotFoundException {
            super("/dev/null");
        }

        @Override
        public void println(String str) {
            if (this.content != null) {
                this.content.add(str);
            }
        }
    }
}

