/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.taint;

import java.util.List;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.CFGraph;
import org.bdware.analysis.InsnPrinter;
import org.bdware.analysis.taint.TaintBB;
import org.bdware.analysis.taint.TaintBits;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class TaintCFG
extends CFGraph {
    public TaintBits taintBits = new TaintBits();

    public TaintCFG(MethodNode mn) {
        super(mn);
    }

    @Override
    public BasicBlock getBasicBlock(int id) {
        return new TaintBB(id);
    }

    public int argsLocal() {
        String desc = this.getMethodNode().desc;
        String[] parameters = desc.split("[)]");
        String parameter = parameters[0];
        String[] args = parameter.split("[;]");
        return args.length - 1;
    }

    public void executeLocal() {
        for (BasicBlock bb : this.basicBlocks) {
            for (AbstractInsnNode an : bb.getInsn()) {
                if (!(an instanceof InvokeDynamicInsnNode)) continue;
                InvokeDynamicInsnNode inDy = (InvokeDynamicInsnNode)an;
                if (!inDy.name.contains("dyn:call:executeContract")) continue;
                this.taintBits.allocate(inDy.name + inDy.hashCode());
            }
        }
    }

    @Override
    public void printSelf() {
        InsnPrinter printer = new InsnPrinter(262144, System.out);
        printer.setLabelOrder(this.getLabelOrder());
        System.out.println("======Method:" + this.getMethodNode().name + this.getMethodNode().desc + "=======");
        System.out.println("=====TaintInfo: " + this.taintBits.taintInfo() + "===========");
        for (BasicBlock bb : this.basicBlocks) {
            System.out.print("==B" + bb.blockID);
            if (this.getSucBlocks(bb).size() > 0) {
                System.out.print("-->");
            }
            for (BasicBlock suc : this.getSucBlocks(bb)) {
                System.out.print(" B" + suc.blockID);
            }
            System.out.println("==");
            TaintBB b = (TaintBB)bb;
            if (b.preResult != null) {
                System.out.print("\u524d\u5e8f\u5206\u6790\u7ed3\u679c\uff1a");
                b.preResult.printResult();
            }
            for (AbstractInsnNode an : bb.getInsn()) {
                an.accept(printer);
            }
        }
    }

    public TaintBB getLastBlock() {
        if (this.basicBlocks != null && this.basicBlocks.size() > 0) {
            return (TaintBB)this.basicBlocks.get(this.basicBlocks.size() - 1);
        }
        return null;
    }

    public List<BasicBlock> getBlocks() {
        return this.basicBlocks;
    }
}

