/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeSerialIndex {
    private static final Logger LOGGER = LogManager.getLogger(TimeSerialIndex.class);
    RandomAccessFile file;
    long fileSize = 0L;

    public TimeSerialIndex(String fileName) {
        try {
            File f = new File(fileName);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                LOGGER.trace("create directory " + parent.getAbsolutePath() + ": " + parent.mkdirs());
            }
            if (!f.exists()) {
                LOGGER.trace("create file " + f.getAbsolutePath() + ": " + f.createNewFile());
            }
            this.file = new RandomAccessFile(f, "rw");
            this.fileSize = this.file.length() / 16L;
            this.file.seek(this.fileSize * 16L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void finalize() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized long index(long hash) {
        long ret = 0L;
        try {
            ++this.fileSize;
            ret = System.currentTimeMillis();
            this.file.writeLong(ret);
            this.file.writeLong(hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Long> request(long offset, int len) {
        ArrayList<Long> ret = new ArrayList<Long>();
        if (offset < 0L) {
            offset = 0L;
        }
        if (offset < this.fileSize) {
            long pos = 0L;
            try {
                pos = this.file.getFilePointer();
                this.file.seek(2L * offset * 8L);
                while (offset < this.fileSize && len > 0) {
                    this.file.readLong();
                    ret.add(this.file.readLong());
                    ++offset;
                    --len;
                }
                this.file.seek(pos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.file.seek(pos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }
        return new ArrayList<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<IndexEntry> requestIndexEntry(long offset, int len) {
        ArrayList<IndexEntry> ret = new ArrayList<IndexEntry>();
        if (offset < 0L) {
            offset = 0L;
        }
        if (offset < this.fileSize) {
            long pos = 0L;
            try {
                pos = this.file.getFilePointer();
                this.file.seek(2L * offset * 8L);
                while (offset < this.fileSize && len > 0) {
                    IndexEntry entry = new IndexEntry();
                    entry.key = this.file.readLong();
                    entry.value = this.file.readLong();
                    ret.add(entry);
                    ++offset;
                    --len;
                }
                this.file.seek(pos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.file.seek(pos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }
        return new ArrayList<IndexEntry>();
    }

    private long getIndex(long offset) {
        if (offset < this.fileSize) {
            try {
                this.file.seek(2L * offset * 8L);
                return this.file.readLong();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalStateException("Array out of index exception");
    }

    public long size() {
        return this.fileSize;
    }

    public synchronized List<Long> requestLast(int count) {
        long offset = this.fileSize - (long)count;
        return this.request(offset, count);
    }

    public synchronized long findNearest(long timeStamp) {
        try {
            long pos = this.file.getFilePointer();
            long ret = this.binarySearch(0L, this.fileSize, timeStamp);
            this.file.seek(pos);
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private long binarySearch(long start, long end, long timeStamp) {
        if (end <= 0L) {
            return end;
        }
        if (start >= end - 1L) {
            long key = this.getIndex(end - 1L);
            if (key >= timeStamp) {
                return end - 1L;
            }
            return end;
        }
        long mid = (start + end) / 2L;
        long key = this.getIndex(mid);
        if (key >= timeStamp) {
            return this.binarySearch(start, mid, timeStamp);
        }
        return this.binarySearch(mid + 1L, end, timeStamp);
    }

    public synchronized void manullyIndex(long date, long key) {
        try {
            ++this.fileSize;
            this.file.writeLong(date);
            this.file.writeLong(key);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class IndexEntry {
        public long key;
        public long value;
    }
}

