/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.visitor;

import java.util.List;
import org.bdware.sc.node.ClassNode;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.parser.YJSParser;
import org.bdware.sc.parser.YJSParserBaseVisitor;
import org.bdware.sc.visitor.FunctionReader;

public class ClassReader
extends YJSParserBaseVisitor<ClassNode> {
    ClassNode cn;
    String fileName;

    public ClassReader(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public ClassNode visitClassDeclaration(YJSParser.ClassDeclarationContext ctx) {
        this.cn = new ClassNode(ctx.Identifier().toString(), this.fileName);
        this.cn.setLine(ctx.start.getLine());
        this.cn.setPos(ctx.start.getCharPositionInLine());
        this.cn.setInterval(ctx.getSourceInterval());
        ctx.classTail().accept(this);
        return this.cn;
    }

    @Override
    public ClassNode visitClassTail(YJSParser.ClassTailContext ctx) {
        List<YJSParser.ClassElementContext> clzElements = ctx.classElement();
        if (clzElements != null) {
            for (YJSParser.ClassElementContext clzElement : clzElements) {
                FunctionReader node = new FunctionReader(this.fileName);
                FunctionNode function = node.visitMethodDefinition(clzElement.methodDefinition());
                if (null != clzElement.Static()) {
                    function.setStatic(true);
                }
                this.cn.addFunction(function);
            }
        }
        return this.cn;
    }
}

