/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.commParser.BDLedger;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashMap;
import org.bdware.sc.util.HashUtil;
import org.bdware.sc.util.JsonUtil;

public class Transaction {
    public byte[] srcID;
    public byte[] dstID;
    public long nonce;
    public int type;
    public byte[] data;
    public int timestamp;
    public byte[] hash;

    public static Transaction fromBytes(byte[] bytes) {
        try {
            Transaction trans = new Transaction();
            DataInputStream bin = new DataInputStream(new ByteArrayInputStream(bytes));
            trans.srcID = new byte[20];
            trans.dstID = new byte[20];
            bin.read(trans.srcID);
            bin.read(trans.dstID);
            trans.nonce = bin.readLong();
            trans.type = bin.readInt();
            int len = bin.readInt();
            trans.data = new byte[len];
            bin.read(trans.data);
            return trans;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getTransactionHash() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] encoded = md.digest(this.toHashByteArray());
            byte[] truned = HashUtil.truncation(encoded, 20);
            System.out.println("[Transaction] encoded:" + HashUtil.byteArray2Str(encoded) + " ==> " + HashUtil.byteArray2Str(truned));
            return truned;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJson() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("SrcID", HashUtil.byteArray2Str(this.srcID));
        ret.put("dstID", HashUtil.byteArray2Str(this.dstID));
        ret.put("nonce", String.valueOf(this.nonce));
        ret.put("type", String.valueOf(this.type));
        ret.put("data", HashUtil.byteArray2Str(this.data));
        return JsonUtil.toJson(ret);
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            DataOutputStream dd = new DataOutputStream(bo);
            dd.write(this.srcID);
            dd.write(this.dstID);
            dd.writeLong(this.nonce);
            dd.writeInt(this.type);
            dd.writeInt(this.data.length);
            dd.write(this.data);
            return bo.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] toHashByteArray() {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            DataOutputStream dd = new DataOutputStream(bo);
            dd.write(this.srcID);
            dd.write(this.dstID);
            dd.writeLong(HashUtil.toLittleEndian(this.nonce));
            dd.writeInt(HashUtil.toLittleEndian(this.type));
            dd.write(this.data);
            return bo.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

