/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.encrypt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Scanner;
import java.util.UUID;

public class HardwareInfo {
    public static OSType type = HardwareInfo.getOSType();

    private static OSType getOSType() {
        String osName = System.getProperty("os.name") + " " + System.getProperty("os.version");
        System.out.println("[HardwareInfo] OS Name:" + osName);
        if (osName.startsWith("Mac")) {
            return OSType.mac;
        }
        if (osName.startsWith("Linux")) {
            return OSType.linux;
        }
        if (osName.contains("Windows")) {
            return OSType.win;
        }
        return OSType.unknown;
    }

    public static String getCPUID() {
        switch (type) {
            case mac: {
                return HardwareInfo.getCPUID_Mac();
            }
            case linux: {
                return HardwareInfo.getCPUID_Linux();
            }
            case win: {
                return HardwareInfo.getCPUID_Windows();
            }
        }
        return "";
    }

    public static String getCPUID_Windows() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"wmic", "cpu", "get", "ProcessorId"});
            process.getOutputStream().close();
            Scanner sc = new Scanner(process.getInputStream());
            String property = sc.next();
            String serial = sc.next();
            System.out.println(property + ": " + serial);
            sc.close();
            return serial;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getCPUID_Linux() {
        Process p;
        StringBuilder result = new StringBuilder();
        String CPU_ID_CMD = "dmidecode";
        try {
            String line;
            p = Runtime.getRuntime().exec(new String[]{"sh", "-c", CPU_ID_CMD});
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                int index = line.toLowerCase().indexOf("uuid");
                if (index < 0) continue;
                result = new StringBuilder(line.substring(index + "uuid".length() + 1).trim());
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("[HardwareInfo] get cpuInfo:" + result + "==");
        if (result.toString().equals("")) {
            try {
                p = Runtime.getRuntime().exec(new String[]{"dmesg"});
                Scanner sc = new Scanner(p.getInputStream());
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    if (!line.contains("Kernel") || !line.contains("UUID")) continue;
                    result = new StringBuilder(line.replaceAll(".*UUID=", ""));
                    result = new StringBuilder(result.toString().replaceAll(" .*$", ""));
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (result.toString().equals("")) {
            Runtime rt = Runtime.getRuntime();
            try {
                String line;
                Process proc = rt.exec("cat /sys/class/dmi/id/product_uuid");
                InputStreamReader isr = new InputStreamReader(proc.getInputStream());
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
                isr.close();
                result = new StringBuilder(result.toString().trim());
                result = new StringBuilder(result.toString().replace(" ", ""));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (result.toString().trim().equals("")) {
            return UUID.randomUUID().toString();
        }
        return result.toString().trim();
    }

    public static String getCPUID_Mac() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"system_profiler", "SPHardwareDataType"});
            Scanner sc = new Scanner(p.getInputStream());
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (!line.contains("Hardware UUID:")) continue;
                line = line.replaceAll(".*:", "");
                sc.close();
                return line;
            }
            sc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static enum OSType {
        mac,
        linux,
        win,
        unknown;

    }
}

