/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.taint;

import java.util.List;
import org.bdware.analysis.taint.HeapObject;
import org.bdware.analysis.taint.TaintBits;
import org.bdware.analysis.taint.TaintResult;
import org.bdware.analysis.taint.TaintValue;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;

public class TaintInterpreter
extends Interpreter<TaintValue> {
    TaintResult currentResult;
    TaintBits taintBits;

    public TaintInterpreter(int api) {
        super(api);
    }

    @Override
    public TaintValue newValue(Type type) {
        if (type != null) {
            return new TaintValue(type.getSize());
        }
        return new TaintValue(1);
    }

    @Override
    public TaintValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        TaintValue ret;
        switch (insn.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                ret = new TaintValue(2);
                break;
            }
            case 187: {
                TypeInsnNode typeNode = (TypeInsnNode)insn;
                if (typeNode.desc.startsWith("wrp/jdk/nashorn/internal/scripts/JO")) {
                    ret = new HeapObject();
                    break;
                }
                ret = new TaintValue(1);
                break;
            }
            default: {
                ret = new TaintValue(1);
            }
        }
        return ret;
    }

    @Override
    public TaintValue copyOperation(AbstractInsnNode insn, TaintValue value) throws AnalyzerException {
        return value;
    }

    @Override
    public TaintValue unaryOperation(AbstractInsnNode insn, TaintValue value) throws AnalyzerException {
        return value;
    }

    @Override
    public TaintValue binaryOperation(AbstractInsnNode insn, TaintValue value1, TaintValue value2) throws AnalyzerException {
        TaintValue ret = new TaintValue(1);
        ret.isTainted = value1.isTainted | value2.isTainted;
        switch (insn.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                ret.size = 2;
            }
        }
        return ret;
    }

    @Override
    public TaintValue ternaryOperation(AbstractInsnNode insn, TaintValue value1, TaintValue value2, TaintValue value3) throws AnalyzerException {
        value1.isTainted |= value3.isTainted;
        return value1;
    }

    @Override
    public TaintValue naryOperation(AbstractInsnNode insn, List<? extends TaintValue> values) throws AnalyzerException {
        long taint;
        int size = 1;
        switch (insn.getOpcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                String desc = ((MethodInsnNode)insn).desc;
                if (desc == null || desc.charAt(desc.length() - 1) != 'D' && desc.charAt(desc.length() - 1) != 'J') break;
                size = 2;
                break;
            }
            case 186: {
                String desc = ((InvokeDynamicInsnNode)insn).desc;
                if (desc != null && (desc.charAt(desc.length() - 1) == 'D' || desc.charAt(desc.length() - 1) == 'J')) {
                    size = 2;
                }
                if (!((InvokeDynamicInsnNode)insn).name.startsWith("dyn:setElem|setProp:") || values.size() != 2) break;
                values.get((int)0).isTainted |= values.get((int)1).isTainted;
                break;
            }
        }
        TaintValue ret = new TaintValue(size);
        for (TaintValue taintValue : values) {
            if (taintValue == null) continue;
            ret.isTainted |= taintValue.isTainted;
        }
        if (insn instanceof InvokeDynamicInsnNode && (taint = this.taintBits.getTaintValue(((InvokeDynamicInsnNode)insn).name + insn.hashCode())) > 0L) {
            ret.isTainted |= taint;
        }
        return HeapObject.operate(insn, values, ret);
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, TaintValue value, TaintValue expected) throws AnalyzerException {
        if (value instanceof HeapObject) {
            this.currentResult.ret.isTainted |= ((HeapObject)value).wholeTaint();
        } else if (value != null) {
            this.currentResult.ret.isTainted |= value.isTainted;
        }
    }

    @Override
    public TaintValue merge(TaintValue v, TaintValue w) {
        TaintValue ret = new TaintValue(v.getSize());
        ret.isTainted |= v.isTainted;
        ret.isTainted |= w.isTainted;
        return ret;
    }

    public void setCurrentResult(TaintResult naiveTaintResult) {
        this.currentResult = naiveTaintResult;
    }

    public void setTaintBits(TaintBits tb) {
        this.taintBits = tb;
    }
}

