/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.conn;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractResult;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.util.JsonUtil;

public class SyncResult {
    static Logger LOGGER = LogManager.getLogger(SyncResult.class);
    public static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer(Executors.defaultThreadFactory(), 5L, TimeUnit.MILLISECONDS, 2);
    static final String TimeoutStr = JsonUtil.toJson(new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("Timeout!")));
    static long syncTime = SyncResult.getSyncTime();
    Map<Long, ResultCallback> waitObj = new ConcurrentHashMap<Long, ResultCallback>();

    private static long getSyncTime() {
        long retVal;
        String timeout = System.getenv("BDW_SOCKET_TIMEOUT");
        if (timeout == null || timeout.isEmpty()) {
            retVal = 10000L;
        } else {
            try {
                retVal = Long.parseLong(timeout);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                retVal = 10000L;
            }
        }
        LOGGER.info("SocketGet Timeout=" + retVal);
        return retVal;
    }

    public void wakeUp(long requestID, String result) {
        ResultCallback ob = this.waitObj.get(requestID);
        this.waitObj.remove(requestID);
        if (ob != null) {
            ob.onResult(result);
        }
    }

    public void sleep(long requestID, ResultCallback cb) {
        TimerTask tt = timeout -> this.wakeUp(requestID, TimeoutStr);
        HASHED_WHEEL_TIMER.newTimeout(tt, 10L, TimeUnit.SECONDS);
    }

    public void sleepWithTimeout(final Long requestID, ResultCallback cb, int timeOut) {
        if (!this.waitObj.containsKey(requestID)) {
            this.waitObj.put(requestID, cb);
        }
        TimerTask tt = new TimerTask(){

            public void run(Timeout timeout) {
                SyncResult.this.wakeUp(requestID, TimeoutStr);
            }
        };
        HASHED_WHEEL_TIMER.newTimeout(tt, (long)timeOut, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String syncSleep(long requestID, ContractResult cr, ResultCallback cb) {
        this.sleep(requestID, cb);
        ResultCallback resultCallback = cb;
        synchronized (resultCallback) {
            try {
                if (this.waitObj.containsKey(requestID)) {
                    cb.wait(syncTime);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (cr.status == ContractResult.Status.Success) {
            return null == cr.result ? null : cr.result.getAsString();
        }
        return JsonUtil.toJson(cr);
    }
}

