/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.node;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.bdware.sc.bean.DoipOperationInfo;
import org.bdware.sc.bean.ForkInfo;
import org.bdware.sc.bean.JoinInfo;
import org.bdware.sc.bean.RouteInfo;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.LogLocation;
import org.bdware.sc.node.LogType;
import org.bdware.sc.node.Script;

public class InterfaceNode
extends Script {
    private final List<AnnotationHook> beforeInvoke;
    private final List<AnnotationHook> afterInvoke;
    public String functionName;
    public List<AnnotationNode> annotations;
    boolean isStatic;
    String fileName;
    EnumSet<LogType> logTypes;
    LogLocation logLocation = new LogLocation();
    private RouteInfo routeInfo;
    private JoinInfo joinInfo;
    private DoipOperationInfo doipOperationInfo;
    private boolean isHandler;
    private boolean isDoipOperation;
    private ForkInfo forkInfo;

    public InterfaceNode(String name, String fileName) {
        this.functionName = name;
        this.fileName = fileName;
        this.annotations = new ArrayList<AnnotationNode>();
        this.logTypes = EnumSet.noneOf(LogType.class);
        this.beforeInvoke = new ArrayList<AnnotationHook>();
        this.afterInvoke = new ArrayList<AnnotationHook>();
    }

    public DoipOperationInfo getDoipOperationInfo() {
        return this.doipOperationInfo;
    }

    public void setDoipOperationInfo(DoipOperationInfo doipOperationInfo) {
        this.doipOperationInfo = doipOperationInfo;
    }

    public void setIsDoipOperation(boolean doipOperation) {
        this.isDoipOperation = doipOperation;
    }

    public boolean isDoipOperation() {
        return this.isDoipOperation;
    }

    public boolean isHandler() {
        return this.isHandler;
    }

    public void setHandler(boolean handler) {
        this.isHandler = handler;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void addAnnotation(AnnotationNode annNode) {
        this.annotations.add(annNode);
    }

    public void addLogType(LogType v) {
        if (v == null) {
            return;
        }
        this.logTypes.add(v);
    }

    public EnumSet<LogType> getLogTypes() {
        return this.logTypes;
    }

    public boolean getLogToBDContract() {
        return this.logLocation.logToBDContract;
    }

    public void setLogToBDContract(boolean b) {
        this.logLocation.logToBDContract = b;
    }

    public boolean getLogToNamedLedger() {
        return this.logLocation.logToNamedLedger;
    }

    public void setLogToNamedLedger(boolean b) {
        this.logLocation.logToNamedLedger = b;
    }

    public void addLedgerName(String name) {
        if (this.logLocation.ledgerNames == null) {
            this.logLocation.ledgerNames = new ArrayList<String>();
        }
        this.logLocation.ledgerNames.add(name);
    }

    public List<String> getLedgerNames() {
        return this.logLocation.ledgerNames;
    }

    public void appendAfterInvokeHandler(AnnotationHook handler) {
        this.afterInvoke.add(handler);
    }

    public List<AnnotationHook> afterExecutionAnnotations() {
        return this.afterInvoke;
    }

    public void appendBeforeInvokeHandler(AnnotationHook handler) {
        this.beforeInvoke.add(handler);
    }

    public List<AnnotationHook> beforeExecutionAnnotations() {
        return this.beforeInvoke;
    }

    public RouteInfo getRouteInfo() {
        return this.routeInfo;
    }

    public void setRouteInfo(RouteInfo routeInfo) {
        this.routeInfo = routeInfo;
    }

    public JoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public void setJoinInfo(JoinInfo joinInfo1) {
        this.joinInfo = joinInfo1;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public AnnotationNode getAnnotation(String annotationName) {
        for (AnnotationNode node : this.annotations) {
            if (node.getType() == null || !node.getType().equals(annotationName)) continue;
            return node;
        }
        return null;
    }

    public void setForkInfo(ForkInfo forkInfo) {
        this.forkInfo = forkInfo;
    }

    public ForkInfo getForkInfo() {
        return this.forkInfo;
    }
}

