/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.db;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.Jedion;

public class KeyValueDBUtil {
    private static final Logger LOGGER = LogManager.getLogger(KeyValueDBUtil.class);
    public static KeyValueDBUtil instance;
    private final Map<String, Jedion> dbLink = new HashMap<String, Jedion>();
    public String dbPath;

    private KeyValueDBUtil(String path) {
        this.dbPath = path;
    }

    public static void setupNC() {
        if (null == instance) {
            instance = new KeyValueDBUtil("./NodeCenterDB");
            LOGGER.info("init nc Jedion in ./NodeCenterDB");
        }
    }

    public static void setupCM() {
        if (null == instance) {
            instance = new KeyValueDBUtil("./ContractManagerDB");
            LOGGER.info("init cm Jedion in ./ContractManagerDB");
        }
    }

    private static void deleteJelck(File file) {
        if (file.exists()) {
            LOGGER.trace("delete file" + file.getAbsolutePath() + ": " + file.delete());
        }
    }

    private Jedion getDB(String dbName) {
        if (!this.dbLink.containsKey(dbName)) {
            this.setupDB(dbName);
        }
        return this.dbLink.get(dbName);
    }

    public boolean containsKey(String dbName, String key) {
        String res = this.getValue(dbName, key);
        return res != null && !res.isEmpty();
    }

    public List<String> getKeys(String dbName) {
        Jedion db = this.getDB(dbName);
        return db.getEveryItem();
    }

    public List<Jedion.KV> getKeyValues(String dbName) {
        Jedion db = this.getDB(dbName);
        return db.getEveryKeyValue();
    }

    public String getValue(String dbName, String key) {
        try {
            Jedion db = this.getDB(dbName);
            return db.readFromDatabase(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setValue(String dbName, String key, String value) {
        try {
            Jedion db = this.getDB(dbName);
            db.writeToDatabase(key, value, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void delete(String dbName, String key) {
        try {
            Jedion db = this.getDB(dbName);
            db.deleteFromDatabase(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupDB(String dbName) {
        Jedion db = new Jedion(dbName);
        File file = new File(this.dbPath + "/" + dbName);
        KeyValueDBUtil.deleteJelck(new File(file, "je.lck"));
        if (!file.exists()) {
            LOGGER.trace("create directory " + file.getAbsolutePath() + ": " + file.mkdirs());
        }
        db.configEnvironment(file);
        db.createDatabase();
        this.dbLink.put(dbName, db);
    }

    public long getCount(String dbName) {
        try {
            Jedion db = this.getDB(dbName);
            return db.getCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void visitDB(String dbName, Jedion.JedionVisitor visitor) {
        try {
            Jedion db = this.getDB(dbName);
            db.visitAllItem(visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

