/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.gen;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bdware.sc.py.bean.PYClass;
import org.bdware.sc.py.bean.PYMethod;
import org.bdware.sc.py.bean.PYModule;
import org.bdware.sc.py.bean.PYPackage;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class PYGenerator
implements Opcodes {
    static final String PKG_NAME = "com/yancloud/callpy/";
    private PYPackage pkgObj;

    public PYPackage getPkgObj() {
        return this.pkgObj;
    }

    public void setPkgObj(PYPackage pkgObj) {
        this.pkgObj = pkgObj;
    }

    public void genClassFiles(ZipOutputStream zout, PYPackage pyPkg) throws Exception {
        if (null == pyPkg) {
            if (null == this.pkgObj) {
                System.out.println("please use setPkgObj method to specify pkgObj");
                return;
            }
        } else {
            this.pkgObj = pyPkg;
        }
        Map<String, byte[]> clzs = this.genClasses();
        HashSet dirs = new HashSet();
        for (String str : clzs.keySet()) {
            System.out.println("[PYGenerator] genFile:" + str);
            zout.putNextEntry(new ZipEntry(str + ".class"));
            zout.write(clzs.get(str));
            zout.closeEntry();
            System.out.println("add entry:" + str + ".class");
        }
    }

    private void putDirs(Set<String> dirs, String dir, ZipOutputStream zout) throws IOException {
        if (!dirs.contains(dir = dir.replaceAll("[^/]*$", "")) && dir.length() > 1) {
            this.putDirs(dirs, dir.substring(0, dir.length() - 1), zout);
            zout.putNextEntry(new ZipEntry(dir));
            zout.closeEntry();
            dirs.add(dir);
            System.out.println("add entry:" + dir);
        }
    }

    public Map<String, byte[]> genClasses() {
        HashMap<String, byte[]> clzs = new HashMap<String, byte[]>();
        String pkgName = this.pkgObj.getName();
        System.out.println("[genClasses]pkgName:  " + pkgName);
        for (PYModule module : this.pkgObj.getModules()) {
            String moduleName = module.getName();
            System.out.println("[genClasses]moduleName: " + moduleName);
            this.genClasses(clzs, module.getClzList(), pkgName + "_" + moduleName + "_");
            this.genFuncs(clzs, module.getFuncList(), pkgName + "_" + moduleName);
        }
        return clzs;
    }

    private void genFuncs(Map<String, byte[]> clzs, List<PYMethod> funcList, String classNameStr) {
        System.out.println("[genFuncs]className: " + classNameStr);
        if (funcList.size() > 0) {
            ClassWriter cw = new ClassWriter(2);
            cw.visit(51, 33, PKG_NAME + classNameStr, null, "com/yancloud/py/bean/PYObject", null);
            for (PYMethod pyFunction : funcList) {
                String functionName = pyFunction.getName();
                MethodVisitor mv = cw.visitMethod(137, functionName, "([Ljava/lang/Object;)Ljava/lang/String;", null, null);
                mv.visitCode();
                Label l0 = new Label();
                mv.visitLabel(l0);
                mv.visitTypeInsn(187, "com/yancloud/py/bean/PYMethodParams");
                mv.visitInsn(89);
                mv.visitMethodInsn(183, "com/yancloud/py/bean/PYMethodParams", "<init>", "()V");
                mv.visitVarInsn(58, 1);
                Label l1 = new Label();
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, "com/yancloud/py/bean/PYMethodParams", "setParams", "(Ljava/lang/Object;)V");
                Label l2 = new Label();
                mv.visitLabel(l2);
                mv.visitFieldInsn(178, "com/yancloud/py/PYEntry", "instance", "Lcom/yancloud/py/PYEntry;");
                mv.visitLdcInsn(classNameStr);
                mv.visitLdcInsn(functionName);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "com/yancloud/py/PYEntry", "invokeModuleFunc", "(Ljava/lang/String;Ljava/lang/String;Lcom/yancloud/py/bean/PYMethodParams;)Ljava/lang/String;");
                mv.visitInsn(176);
                Label l3 = new Label();
                mv.visitLabel(l3);
                mv.visitLocalVariable("params", "[Ljava/lang/Object;", null, l0, l3, 0);
                mv.visitLocalVariable("paramObj", "Lcom/yancloud/py/bean/PYMethodParams;", null, l1, l3, 1);
                mv.visitMaxs(4, 2);
                mv.visitEnd();
            }
            cw.visitEnd();
            byte[] b = cw.toByteArray();
            clzs.put(PKG_NAME + classNameStr, b);
        }
    }

    private void genClasses(Map<String, byte[]> clzs, List<PYClass> clzList, String moduleSig) {
        for (PYClass pyClass : clzList) {
            Label l3;
            Label l2;
            Label l1;
            Label l0;
            String className = pyClass.getName();
            ClassWriter cw = new ClassWriter(2);
            String classNameStr = moduleSig + className;
            System.out.println("[genClasses]className: " + classNameStr);
            cw.visit(51, 33, PKG_NAME + classNameStr, null, "com/yancloud/py/bean/PYObject", null);
            MethodVisitor mv = cw.visitMethod(129, "<init>", "([Ljava/lang/Object;)V", null, null);
            mv.visitCode();
            Iterator<PYMethod> l02 = new Label();
            mv.visitLabel((Label)((Object)l02));
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "com/yancloud/py/bean/PYObject", "<init>", "()V");
            Label l12 = new Label();
            mv.visitLabel(l12);
            mv.visitTypeInsn(187, "com/yancloud/py/bean/PYMethodParams");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "com/yancloud/py/bean/PYMethodParams", "<init>", "()V");
            mv.visitVarInsn(58, 2);
            Label l22 = new Label();
            mv.visitLabel(l22);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "com/yancloud/py/bean/PYMethodParams", "setParams", "(Ljava/lang/Object;)V");
            Label l32 = new Label();
            mv.visitLabel(l32);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, "com/yancloud/py/PYEntry", "instance", "Lcom/yancloud/py/PYEntry;");
            mv.visitLdcInsn(classNameStr);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, "com/yancloud/py/PYEntry", "creatObject", "(Ljava/lang/String;Lcom/yancloud/py/bean/PYMethodParams;)Ljava/lang/String;");
            mv.visitMethodInsn(182, PKG_NAME + classNameStr, "setID", "(Ljava/lang/String;)V");
            Label l4 = new Label();
            mv.visitLabel(l4);
            mv.visitInsn(177);
            Label l5 = new Label();
            mv.visitLabel(l5);
            mv.visitLocalVariable("this", "Lcom/yancloud/gen/P$M$C;", null, (Label)((Object)l02), l5, 0);
            mv.visitLocalVariable("params", "[Ljava/lang/Object;", null, (Label)((Object)l02), l5, 1);
            mv.visitLocalVariable("paramObj", "Lcom/yancloud/py/bean/PYMethodParams;", null, l22, l5, 2);
            mv.visitMaxs(4, 3);
            mv.visitEnd();
            for (PYMethod pyMethod : pyClass.getMethods()) {
                String methodName = pyMethod.getName();
                if (pyMethod.isStatic()) {
                    mv = cw.visitMethod(137, methodName, "([Ljava/lang/Object;)Ljava/lang/String;", null, null);
                    mv.visitCode();
                    l0 = new Label();
                    mv.visitLabel(l0);
                    mv.visitTypeInsn(187, "com/yancloud/py/bean/PYMethodParams");
                    mv.visitInsn(89);
                    mv.visitMethodInsn(183, "com/yancloud/py/bean/PYMethodParams", "<init>", "()V");
                    mv.visitVarInsn(58, 1);
                    l1 = new Label();
                    mv.visitLabel(l1);
                    mv.visitVarInsn(25, 1);
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(182, "com/yancloud/py/bean/PYMethodParams", "setParams", "(Ljava/lang/Object;)V");
                    l2 = new Label();
                    mv.visitLabel(l2);
                    mv.visitFieldInsn(178, "com/yancloud/py/PYEntry", "instance", "Lcom/yancloud/py/PYEntry;");
                    mv.visitLdcInsn(classNameStr + "." + methodName);
                    mv.visitVarInsn(25, 1);
                    mv.visitMethodInsn(182, "com/yancloud/py/PYEntry", "invokeClzStaticMethod", "(Ljava/lang/String;Lcom/yancloud/py/bean/PYMethodParams;)Ljava/lang/String;");
                    mv.visitInsn(176);
                    l3 = new Label();
                    mv.visitLabel(l3);
                    mv.visitLocalVariable("params", "[Ljava/lang/Object;", null, l0, l3, 0);
                    mv.visitLocalVariable("paramObj", "Lcom/yancloud/py/bean/PYMethodParams;", null, l1, l3, 1);
                    mv.visitMaxs(3, 2);
                    mv.visitEnd();
                    continue;
                }
                mv = cw.visitMethod(129, methodName, "([Ljava/lang/Object;)Ljava/lang/String;", null, null);
                mv.visitCode();
                l0 = new Label();
                mv.visitLabel(l0);
                mv.visitTypeInsn(187, "com/yancloud/py/bean/PYMethodParams");
                mv.visitInsn(89);
                mv.visitMethodInsn(183, "com/yancloud/py/bean/PYMethodParams", "<init>", "()V");
                mv.visitVarInsn(58, 2);
                l1 = new Label();
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "com/yancloud/py/bean/PYMethodParams", "setParams", "(Ljava/lang/Object;)V");
                l2 = new Label();
                mv.visitLabel(l2);
                mv.visitFieldInsn(178, "com/yancloud/py/PYEntry", "instance", "Lcom/yancloud/py/PYEntry;");
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, "com/yancloud/gen/P$M$C", "getID", "()Ljava/lang/String;");
                mv.visitLdcInsn(classNameStr + "." + methodName);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, "com/yancloud/py/PYEntry", "invokeObjectMethod", "(Ljava/lang/String;Ljava/lang/String;Lcom/yancloud/py/bean/PYMethodParams;)Ljava/lang/String;");
                mv.visitInsn(176);
                l3 = new Label();
                mv.visitLabel(l3);
                mv.visitLocalVariable("this", "Lcom/yancloud/gen/P$M$C;", null, l0, l3, 0);
                mv.visitLocalVariable("params", "[Ljava/lang/Object;", null, l0, l3, 1);
                mv.visitLocalVariable("paramObj", "Lcom/yancloud/py/bean/PYMethodParams;", null, l1, l3, 2);
                mv.visitMaxs(4, 3);
                mv.visitEnd();
            }
            for (PYMethod pyFunction : pyClass.getFuncs()) {
                String functionName = pyFunction.getName();
                mv = cw.visitMethod(129, functionName, "([Ljava/lang/Object;)Ljava/lang/String;", null, null);
                mv.visitCode();
                l0 = new Label();
                mv.visitLabel(l0);
                mv.visitTypeInsn(187, "com/yancloud/py/bean/PYMethodParams");
                mv.visitInsn(89);
                mv.visitMethodInsn(183, "com/yancloud/py/bean/PYMethodParams", "<init>", "()V");
                mv.visitVarInsn(58, 2);
                l1 = new Label();
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "com/yancloud/py/bean/PYMethodParams", "setParams", "(Ljava/lang/Object;)V");
                l2 = new Label();
                mv.visitLabel(l2);
                mv.visitFieldInsn(178, "com/yancloud/py/PYEntry", "instance", "Lcom/yancloud/py/PYEntry;");
                mv.visitLdcInsn(classNameStr + "." + functionName);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, "com/yancloud/py/PYEntry", "invokeClzClassMethod", "(Ljava/lang/String;Lcom/yancloud/py/bean/PYMethodParams;)Ljava/lang/String;");
                mv.visitInsn(176);
                l3 = new Label();
                mv.visitLabel(l3);
                mv.visitLocalVariable("this", "Lcom/yancloud/gen/P$M$C;", null, l0, l3, 0);
                mv.visitLocalVariable("params", "[Ljava/lang/Object;", null, l0, l3, 1);
                mv.visitLocalVariable("paramObj", "Lcom/yancloud/py/bean/PYMethodParams;", null, l1, l3, 2);
                mv.visitMaxs(3, 3);
                mv.visitEnd();
            }
            cw.visitEnd();
            byte[] b = cw.toByteArray();
            clzs.put(PKG_NAME + classNameStr, b);
        }
    }
}

