/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Scanner;
import org.bdware.sc.util.JsonUtil;

public class ApiGate {
    private final Get get;

    public ApiGate(String ipAddress, int port) {
        this.get = new HttpGet(ipAddress, port);
    }

    public ApiGate(String ipAddress) {
        this.get = new HttpGet(ipAddress, 6161);
    }

    public String get(String pkgName, String method, String arg) {
        return this.get.get(pkgName, method, arg);
    }

    private static class HttpGet
    implements Get {
        String url;

        public HttpGet(String ip, int port) {
            this.url = "http://" + ip + ":" + port + "/CMDManager?getMessage=";
        }

        @Override
        public String get(String pkgName, String name, String arg) {
            Args args = new Args();
            args.pkgName = pkgName;
            args.method = name;
            args.arg = arg;
            return this.sendHttpGet(this.url + URLEncoder.encode(JsonUtil.toJson(args)));
        }

        private String sendHttpGet(String str) {
            try {
                System.out.println("[APIGate] sendHttp:" + str);
                URL url = new URL(str);
                URLConnection connection = url.openConnection();
                connection.setReadTimeout(10000);
                InputStream input = connection.getInputStream();
                Scanner sc = new Scanner(input);
                StringBuilder sb = new StringBuilder();
                while (sc.hasNextLine()) {
                    sb.append(sc.nextLine()).append("\n");
                }
                sc.close();
                return sb.toString();
            }
            catch (Exception e) {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(bo));
                return bo.toString();
            }
        }
    }

    static class Args {
        String pkgName;
        String method;
        String arg;

        Args() {
        }
    }

    private static interface Get {
        public String get(String var1, String var2, String var3);
    }
}

