/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.RetryUtil;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import com.alibaba.datax.core.util.SecretUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static CredentialsProvider provider;
    private CloseableHttpClient httpClient;
    private static volatile HttpClientUtil clientUtil;
    private static int HTTP_TIMEOUT_INMILLIONSECONDS;
    private static final int POOL_SIZE = 20;
    private static ThreadPoolExecutor asyncExecutor;

    public static void setHttpTimeoutInMillionSeconds(int httpTimeoutInMillionSeconds) {
        HTTP_TIMEOUT_INMILLIONSECONDS = httpTimeoutInMillionSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized HttpClientUtil getHttpClientUtil() {
        if (null != clientUtil) return clientUtil;
        Class<HttpClientUtil> clazz = HttpClientUtil.class;
        synchronized (HttpClientUtil.class) {
            if (null != clientUtil) return clientUtil;
            clientUtil = new HttpClientUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return clientUtil;
        }
    }

    public HttpClientUtil() {
        Properties prob = SecretUtil.getSecurityProperties();
        HttpClientUtil.setBasicAuth(prob.getProperty("auth.user"), prob.getProperty("auth.pass"));
        this.initApacheHttpClient();
    }

    public void destroy() {
        this.destroyApacheHttpClient();
    }

    public static void setBasicAuth(String username, String password) {
        provider = new BasicCredentialsProvider();
        provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    private void initApacheHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(HTTP_TIMEOUT_INMILLIONSECONDS).setConnectTimeout(HTTP_TIMEOUT_INMILLIONSECONDS).setConnectionRequestTimeout(HTTP_TIMEOUT_INMILLIONSECONDS).setStaleConnectionCheckEnabled(true).build();
        this.httpClient = null == provider ? HttpClientBuilder.create().setMaxConnTotal(20).setMaxConnPerRoute(20).setDefaultRequestConfig(requestConfig).build() : HttpClientBuilder.create().setMaxConnTotal(20).setMaxConnPerRoute(20).setDefaultRequestConfig(requestConfig).setDefaultCredentialsProvider(provider).build();
    }

    private void destroyApacheHttpClient() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
                this.httpClient = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HttpGet getGetRequest() {
        return new HttpGet();
    }

    public static HttpPost getPostRequest() {
        return new HttpPost();
    }

    public static HttpPut getPutRequest() {
        return new HttpPut();
    }

    public static HttpDelete getDeleteRequest() {
        return new HttpDelete();
    }

    public String executeAndGet(HttpRequestBase httpRequestBase) throws Exception {
        String entiStr = "";
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequestBase);
        if (response.getStatusLine().getStatusCode() != 200) {
            System.err.println("\u8bf7\u6c42\u5730\u5740\uff1a" + httpRequestBase.getURI() + ", \u8bf7\u6c42\u65b9\u6cd5\uff1a" + httpRequestBase.getMethod() + ",STATUS CODE = " + response.getStatusLine().getStatusCode());
            if (httpRequestBase != null) {
                httpRequestBase.abort();
            }
            throw new Exception("Response Status Code : " + response.getStatusLine().getStatusCode());
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new Exception("Response Entity Is Null");
        }
        entiStr = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
        return entiStr;
    }

    public String executeAndGetWithRetry(final HttpRequestBase httpRequestBase, int retryTimes, long retryInterval) {
        try {
            return RetryUtil.asyncExecuteWithRetry(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return HttpClientUtil.this.executeAndGet(httpRequestBase);
                }
            }, retryTimes, retryInterval, true, HTTP_TIMEOUT_INMILLIONSECONDS + 1000, asyncExecutor);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, e);
        }
    }

    public String executeAndGetWithFailedRetry(final HttpRequestBase httpRequestBase, int retryTimes, long retryInterval) {
        try {
            return RetryUtil.asyncExecuteWithRetry(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String result = HttpClientUtil.this.executeAndGet(httpRequestBase);
                    if (result != null && result.startsWith("{\"result\":-1")) {
                        throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.CALL_REMOTE_FAILED, "\u8fdc\u7a0b\u63a5\u53e3\u8fd4\u56de-1,\u5c06\u91cd\u8bd5");
                    }
                    return result;
                }
            }, retryTimes, retryInterval, true, HTTP_TIMEOUT_INMILLIONSECONDS + 1000, asyncExecutor);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, e);
        }
    }

    static {
        HTTP_TIMEOUT_INMILLIONSECONDS = 5000;
        asyncExecutor = RetryUtil.createThreadPoolExecutor();
    }
}

