/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.writer.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.plugin.rdbms.util.DBUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtilErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import com.alibaba.datax.plugin.rdbms.util.RdbmsException;
import com.alibaba.datax.plugin.rdbms.writer.Constant;
import com.alibaba.druid.sql.parser.ParserException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WriterUtil.class);

    public static List<Configuration> doSplit(Configuration simplifiedConf, int adviceNumber) {
        ArrayList<Configuration> splitResultConfigs = new ArrayList<Configuration>();
        int tableNumber = simplifiedConf.getInt(Constant.TABLE_NUMBER_MARK);
        if (tableNumber == 1) {
            for (int j = 0; j < adviceNumber; ++j) {
                splitResultConfigs.add(simplifiedConf.clone());
            }
            return splitResultConfigs;
        }
        if (tableNumber != adviceNumber) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.CONF_ERROR, String.format("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef. \u60a8\u8981\u5199\u5165\u7684\u76ee\u7684\u7aef\u7684\u8868\u4e2a\u6570\u662f:%s , \u4f46\u662f\u6839\u636e\u7cfb\u7edf\u5efa\u8bae\u9700\u8981\u5207\u5206\u7684\u4efd\u6570\u662f\uff1a%s. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", tableNumber, adviceNumber));
        }
        List<String> preSqls = simplifiedConf.getList("preSql", String.class);
        List<String> postSqls = simplifiedConf.getList("postSql", String.class);
        List<Object> conns = simplifiedConf.getList(Constant.CONN_MARK, Object.class);
        for (Object conn : conns) {
            Configuration sliceConfig = simplifiedConf.clone();
            Configuration connConf = Configuration.from(conn.toString());
            String jdbcUrl = connConf.getString("jdbcUrl");
            sliceConfig.set("jdbcUrl", jdbcUrl);
            sliceConfig.remove(Constant.CONN_MARK);
            List<String> tables = connConf.getList("table", String.class);
            for (String table : tables) {
                Configuration tempSlice = sliceConfig.clone();
                tempSlice.set("table", table);
                tempSlice.set("preSql", WriterUtil.renderPreOrPostSqls(preSqls, table));
                tempSlice.set("postSql", WriterUtil.renderPreOrPostSqls(postSqls, table));
                splitResultConfigs.add(tempSlice);
            }
        }
        return splitResultConfigs;
    }

    public static List<String> renderPreOrPostSqls(List<String> preOrPostSqls, String tableName) {
        if (null == preOrPostSqls) {
            return Collections.emptyList();
        }
        ArrayList<String> renderedSqls = new ArrayList<String>();
        for (String sql : preOrPostSqls) {
            if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
            renderedSqls.add(sql.replace(Constant.TABLE_NAME_PLACEHOLDER, tableName));
        }
        return renderedSqls;
    }

    public static void executeSqls(Connection conn, List<String> sqls, String basicMessage, DataBaseType dataBaseType) {
        Statement stmt = null;
        String currentSql = null;
        try {
            stmt = conn.createStatement();
            Iterator<String> i$ = sqls.iterator();
            while (i$.hasNext()) {
                String sql;
                currentSql = sql = i$.next();
                DBUtil.executeSqlWithoutResultSet(stmt, sql);
            }
        }
        catch (Exception e) {
            throw RdbmsException.asQueryException(dataBaseType, e, currentSql, null, null);
        }
        finally {
            DBUtil.closeDBResources(null, stmt, null);
        }
    }

    public static String getWriteTemplate(List<String> columnHolders, List<String> valueHolders, String writeMode, DataBaseType dataBaseType, boolean forceUseUpdate) {
        String writeDataSqlTemplate;
        boolean isWriteModeLegal;
        boolean bl = isWriteModeLegal = writeMode.trim().toLowerCase().startsWith("insert") || writeMode.trim().toLowerCase().startsWith("replace") || writeMode.trim().toLowerCase().startsWith("update");
        if (!isWriteModeLegal) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_VALUE, String.format("\u60a8\u6240\u914d\u7f6e\u7684 writeMode:%s \u9519\u8bef. \u56e0\u4e3aDataX \u76ee\u524d\u4ec5\u652f\u6301replace,update \u6216 insert \u65b9\u5f0f. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", writeMode));
        }
        if (forceUseUpdate || (dataBaseType == DataBaseType.MySql || dataBaseType == DataBaseType.Tddl) && writeMode.trim().toLowerCase().startsWith("update")) {
            writeDataSqlTemplate = "INSERT INTO %s (" + StringUtils.join(columnHolders, (String)",") + ") VALUES(" + StringUtils.join(valueHolders, (String)",") + ")" + WriterUtil.onDuplicateKeyUpdateString(columnHolders);
        } else {
            if (writeMode.trim().toLowerCase().startsWith("update")) {
                writeMode = "replace";
            }
            writeDataSqlTemplate = writeMode + " INTO %s (" + StringUtils.join(columnHolders, (String)",") + ") VALUES(" + StringUtils.join(valueHolders, (String)",") + ")";
        }
        return writeDataSqlTemplate;
    }

    public static String onDuplicateKeyUpdateString(List<String> columnHolders) {
        if (columnHolders == null || columnHolders.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ON DUPLICATE KEY UPDATE ");
        boolean first = true;
        for (String column : columnHolders) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(column);
            sb.append("=VALUES(");
            sb.append(column);
            sb.append(")");
        }
        return sb.toString();
    }

    public static void preCheckPrePareSQL(Configuration originalConfig, DataBaseType type) {
        List<Object> conns = originalConfig.getList(Constant.CONN_MARK, Object.class);
        Configuration connConf = Configuration.from(conns.get(0).toString());
        String table = connConf.getList("table", String.class).get(0);
        List<String> preSqls = originalConfig.getList("preSql", String.class);
        List<String> renderedPreSqls = WriterUtil.renderPreOrPostSqls(preSqls, table);
        if (null != renderedPreSqls && !renderedPreSqls.isEmpty()) {
            LOG.info("Begin to preCheck preSqls:[{}].", (Object)StringUtils.join(renderedPreSqls, (String)";"));
            for (String sql : renderedPreSqls) {
                try {
                    DBUtil.sqlValid(sql, type);
                }
                catch (ParserException e) {
                    throw RdbmsException.asPreSQLParserException(type, (Exception)((Object)e), sql);
                }
            }
        }
    }

    public static void preCheckPostSQL(Configuration originalConfig, DataBaseType type) {
        List<Object> conns = originalConfig.getList(Constant.CONN_MARK, Object.class);
        Configuration connConf = Configuration.from(conns.get(0).toString());
        String table = connConf.getList("table", String.class).get(0);
        List<String> postSqls = originalConfig.getList("postSql", String.class);
        List<String> renderedPostSqls = WriterUtil.renderPreOrPostSqls(postSqls, table);
        if (null != renderedPostSqls && !renderedPostSqls.isEmpty()) {
            LOG.info("Begin to preCheck postSqls:[{}].", (Object)StringUtils.join(renderedPostSqls, (String)";"));
            for (String sql : renderedPostSqls) {
                try {
                    DBUtil.sqlValid(sql, type);
                }
                catch (ParserException e) {
                    throw RdbmsException.asPostSQLParserException(type, (Exception)((Object)e), sql);
                }
            }
        }
    }
}

