/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.DateColumn;
import com.alibaba.datax.common.element.DoubleColumn;
import com.alibaba.datax.common.element.LongColumn;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import com.alibaba.datax.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.maskingMethods.anonymity.FloorMasker;
import java.util.Arrays;
import java.util.Date;

public class FloorTransformer
extends Transformer {
    private Object masker;
    String key;
    int columnIndex;

    public FloorTransformer() {
        this.setTransformerName("dx_floor");
        System.out.println("Using floor masker");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        try {
            if (paras.length < 2) {
                throw new RuntimeException("Floor transformer\u7f3a\u5c11\u53c2\u6570");
            }
            this.columnIndex = (Integer)paras[0];
            this.key = String.valueOf(paras[1]);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(this.columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                return record;
            }
            if (column.getType() == Column.Type.DATE) {
                Date newValue = FloorMasker.mask(column.asDate(), this.key);
                record.setColumn(this.columnIndex, new DateColumn(newValue));
            } else if (column.getType() == Column.Type.LONG || column.getType() == Column.Type.INT) {
                int mod = 0;
                mod = this.key.isEmpty() ? 10 : Integer.valueOf(this.key);
                long newValue = FloorMasker.mask(column.asLong(), mod);
                record.setColumn(this.columnIndex, new LongColumn(newValue));
            } else if (column.getType() == Column.Type.DOUBLE) {
                Double newValue = FloorMasker.mask(column.asDouble());
                record.setColumn(this.columnIndex, new DoubleColumn(newValue));
            }
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }
}

