/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.element;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.ColumnCast;
import com.alibaba.datax.common.exception.CommonErrorCode;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;

public class BytesColumn
extends Column {
    public BytesColumn() {
        this(null);
    }

    public BytesColumn(byte[] bytes) {
        super(ArrayUtils.clone((byte[])bytes), Column.Type.BYTES, null == bytes ? 0 : bytes.length);
    }

    @Override
    public byte[] asBytes() {
        if (null == this.getRawData()) {
            return null;
        }
        return (byte[])this.getRawData();
    }

    @Override
    public String asString() {
        if (null == this.getRawData()) {
            return null;
        }
        try {
            return ColumnCast.bytes2String(this);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Bytes[%s]\u4e0d\u80fd\u8f6c\u4e3aString .", this.toString()));
        }
    }

    @Override
    public Long asLong() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aLong .");
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBigDecimal .");
    }

    @Override
    public BigInteger asBigInteger() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBigInteger .");
    }

    @Override
    public Double asDouble() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aLong .");
    }

    @Override
    public Date asDate() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aDate .");
    }

    @Override
    public Boolean asBoolean() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBoolean .");
    }
}

