/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.reader;

import com.alibaba.datax.common.element.BoolColumn;
import com.alibaba.datax.common.element.BytesColumn;
import com.alibaba.datax.common.element.DateColumn;
import com.alibaba.datax.common.element.DoubleColumn;
import com.alibaba.datax.common.element.LongColumn;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.RecordSender;
import com.alibaba.datax.common.plugin.TaskPluginCollector;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.statistics.PerfRecord;
import com.alibaba.datax.common.statistics.PerfTrace;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.plugin.rdbms.reader.Constant;
import com.alibaba.datax.plugin.rdbms.reader.util.OriginalConfPretreatmentUtil;
import com.alibaba.datax.plugin.rdbms.reader.util.PreCheckTask;
import com.alibaba.datax.plugin.rdbms.reader.util.ReaderSplitUtil;
import com.alibaba.datax.plugin.rdbms.reader.util.SingleTableSplitUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtilErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import com.alibaba.datax.plugin.rdbms.util.RdbmsException;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonRdbmsReader {

    public static class Task {
        private static final Logger LOG = LoggerFactory.getLogger(Task.class);
        private static final boolean IS_DEBUG = LOG.isDebugEnabled();
        protected final byte[] EMPTY_CHAR_ARRAY = new byte[0];
        private DataBaseType dataBaseType;
        private int taskGroupId = -1;
        private int taskId = -1;
        private String username;
        private String password;
        private String jdbcUrl;
        private String mandatoryEncoding;
        private String basicMsg;

        public Task(DataBaseType dataBaseType) {
            this(dataBaseType, -1, -1);
        }

        public Task(DataBaseType dataBaseType, int taskGropuId, int taskId) {
            this.dataBaseType = dataBaseType;
            this.taskGroupId = taskGropuId;
            this.taskId = taskId;
        }

        public void init(Configuration readerSliceConfig) {
            this.username = readerSliceConfig.getString("username");
            this.password = readerSliceConfig.getString("password");
            this.jdbcUrl = readerSliceConfig.getString("jdbcUrl");
            if (this.jdbcUrl.startsWith("||_dsc_ob10_dsc_||") && this.dataBaseType == DataBaseType.MySql) {
                String[] ss = this.jdbcUrl.split("\\|\\|_dsc_ob10_dsc_\\|\\|");
                if (ss.length != 3) {
                    throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.JDBC_OB10_ADDRESS_ERROR, "JDBC OB10\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfbaskdatax");
                }
                LOG.info("this is ob1_0 jdbc url.");
                this.username = ss[1].trim() + ":" + this.username;
                this.jdbcUrl = ss[2];
                LOG.info("this is ob1_0 jdbc url. user=" + this.username + " :url=" + this.jdbcUrl);
            }
            this.mandatoryEncoding = readerSliceConfig.getString("mandatoryEncoding", "");
            this.basicMsg = String.format("jdbcUrl:[%s]", this.jdbcUrl);
        }

        public void startRead(Configuration readerSliceConfig, RecordSender recordSender, TaskPluginCollector taskPluginCollector, int fetchSize) {
            String querySql = readerSliceConfig.getString("querySql");
            String table = readerSliceConfig.getString("table");
            PerfTrace.getInstance().addTaskDetails(this.taskId, table + "," + this.basicMsg);
            LOG.info("Begin to read record by Sql: [{}\n] {}.", (Object)querySql, (Object)this.basicMsg);
            PerfRecord queryPerfRecord = new PerfRecord(this.taskGroupId, this.taskId, PerfRecord.PHASE.SQL_QUERY);
            queryPerfRecord.start();
            Connection conn = DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.username, this.password);
            DBUtil.dealWithSessionConfig(conn, readerSliceConfig, this.dataBaseType, this.basicMsg);
            int columnNumber = 0;
            ResultSet rs = null;
            try {
                rs = DBUtil.query(conn, querySql, fetchSize);
                queryPerfRecord.end();
                ResultSetMetaData metaData = rs.getMetaData();
                columnNumber = metaData.getColumnCount();
                PerfRecord allResultPerfRecord = new PerfRecord(this.taskGroupId, this.taskId, PerfRecord.PHASE.RESULT_NEXT_ALL);
                allResultPerfRecord.start();
                long rsNextUsedTime = 0L;
                long lastTime = System.nanoTime();
                while (rs.next()) {
                    rsNextUsedTime += System.nanoTime() - lastTime;
                    this.transportOneRecord(recordSender, rs, metaData, columnNumber, this.mandatoryEncoding, taskPluginCollector);
                    lastTime = System.nanoTime();
                }
                allResultPerfRecord.end(rsNextUsedTime);
                LOG.info("Finished read record by Sql: [{}\n] {}.", (Object)querySql, (Object)this.basicMsg);
            }
            catch (Exception e) {
                throw RdbmsException.asQueryException(this.dataBaseType, e, querySql, table, this.username);
            }
            finally {
                DBUtil.closeDBResources(null, conn);
            }
        }

        public void post(Configuration originalConfig) {
        }

        public void destroy(Configuration originalConfig) {
        }

        protected Record transportOneRecord(RecordSender recordSender, ResultSet rs, ResultSetMetaData metaData, int columnNumber, String mandatoryEncoding, TaskPluginCollector taskPluginCollector) {
            Record record = this.buildRecord(recordSender, rs, metaData, columnNumber, mandatoryEncoding, taskPluginCollector);
            recordSender.sendToWriter(record);
            return record;
        }

        protected Record buildRecord(RecordSender recordSender, ResultSet rs, ResultSetMetaData metaData, int columnNumber, String mandatoryEncoding, TaskPluginCollector taskPluginCollector) {
            Record record;
            block19: {
                record = recordSender.createRecord();
                try {
                    block15: for (int i = 1; i <= columnNumber; ++i) {
                        switch (metaData.getColumnType(i)) {
                            case -16: 
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: {
                                String rawData = StringUtils.isBlank((CharSequence)mandatoryEncoding) ? rs.getString(i) : new String(rs.getBytes(i) == null ? this.EMPTY_CHAR_ARRAY : rs.getBytes(i), mandatoryEncoding);
                                record.addColumn(new StringColumn(rawData));
                                continue block15;
                            }
                            case 2005: 
                            case 2011: {
                                record.addColumn(new StringColumn(rs.getString(i)));
                                continue block15;
                            }
                            case -6: 
                            case -5: 
                            case 4: 
                            case 5: {
                                record.addColumn(new LongColumn(rs.getString(i)));
                                continue block15;
                            }
                            case 2: 
                            case 3: {
                                record.addColumn(new DoubleColumn(rs.getString(i)));
                                continue block15;
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                record.addColumn(new DoubleColumn(rs.getString(i)));
                                continue block15;
                            }
                            case 92: {
                                record.addColumn(new DateColumn(rs.getTime(i)));
                                continue block15;
                            }
                            case 91: {
                                if (metaData.getColumnTypeName(i).equalsIgnoreCase("year")) {
                                    record.addColumn(new LongColumn(rs.getInt(i)));
                                    continue block15;
                                }
                                record.addColumn(new DateColumn(rs.getDate(i)));
                                continue block15;
                            }
                            case 93: {
                                record.addColumn(new DateColumn(rs.getTimestamp(i)));
                                continue block15;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 2004: {
                                record.addColumn(new BytesColumn(rs.getBytes(i)));
                                continue block15;
                            }
                            case -7: 
                            case 16: {
                                record.addColumn(new BoolColumn(rs.getBoolean(i)));
                                continue block15;
                            }
                            case 0: {
                                String stringData = null;
                                if (rs.getObject(i) != null) {
                                    stringData = rs.getObject(i).toString();
                                }
                                record.addColumn(new StringColumn(stringData));
                                continue block15;
                            }
                            default: {
                                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.UNSUPPORTED_TYPE, String.format("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef. \u56e0\u4e3aDataX \u4e0d\u652f\u6301\u6570\u636e\u5e93\u8bfb\u53d6\u8fd9\u79cd\u5b57\u6bb5\u7c7b\u578b. \u5b57\u6bb5\u540d:[%s], \u5b57\u6bb5\u540d\u79f0:[%s], \u5b57\u6bb5Java\u7c7b\u578b:[%s]. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u6570\u636e\u5e93\u51fd\u6570\u5c06\u5176\u8f6c\u6362datax\u652f\u6301\u7684\u7c7b\u578b \u6216\u8005\u4e0d\u540c\u6b65\u8be5\u5b57\u6bb5 .", metaData.getColumnName(i), metaData.getColumnType(i), metaData.getColumnClassName(i)));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (IS_DEBUG) {
                        LOG.debug("read data " + record.toString() + " occur exception:", (Throwable)e);
                    }
                    taskPluginCollector.collectDirtyRecord(record, e);
                    if (!(e instanceof DataXException)) break block19;
                    throw (DataXException)e;
                }
            }
            return record;
        }
    }

    public static class Job {
        private static final Logger LOG = LoggerFactory.getLogger(Job.class);

        public Job(DataBaseType dataBaseType) {
            OriginalConfPretreatmentUtil.DATABASE_TYPE = dataBaseType;
            SingleTableSplitUtil.DATABASE_TYPE = dataBaseType;
        }

        public void init(Configuration originalConfig) {
            OriginalConfPretreatmentUtil.doPretreatment(originalConfig);
            LOG.debug("After job init(), job config now is:[\n{}\n]", (Object)originalConfig.toJSON());
        }

        public void preCheck(Configuration originalConfig, DataBaseType dataBaseType) {
            Configuration queryConf = ReaderSplitUtil.doPreCheckSplit(originalConfig);
            String splitPK = queryConf.getString("splitPk");
            List<Object> connList = queryConf.getList(Constant.CONN_MARK, Object.class);
            String username = queryConf.getString("username");
            String password = queryConf.getString("password");
            ExecutorService exec = connList.size() < 10 ? Executors.newFixedThreadPool(connList.size()) : Executors.newFixedThreadPool(10);
            ArrayList<PreCheckTask> taskList = new ArrayList<PreCheckTask>();
            int len = connList.size();
            for (int i = 0; i < len; ++i) {
                Configuration configuration = Configuration.from(connList.get(i).toString());
                PreCheckTask t = new PreCheckTask(username, password, configuration, dataBaseType, splitPK);
                taskList.add(t);
            }
            List<Object> results = Lists.newArrayList();
            try {
                results = exec.invokeAll(taskList);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            for (Future future : results) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    DataXException de = (DataXException)e.getCause();
                    throw de;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            exec.shutdownNow();
        }

        public List<Configuration> split(Configuration originalConfig, int adviceNumber) {
            return ReaderSplitUtil.doSplit(originalConfig, adviceNumber);
        }

        public void post(Configuration originalConfig) {
        }

        public void destroy(Configuration originalConfig) {
        }
    }
}

