/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.bdledger.api.grpc;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bdware.bdledger.api.grpc.GrpcHeaderInterceptor;
import org.bdware.bdledger.api.grpc.Utils;
import org.bdware.bdledger.api.grpc.pb.CommonProto;
import org.bdware.bdledger.api.grpc.pb.LedgerGrpc;
import org.bdware.bdledger.api.grpc.pb.LedgerProto;
import org.bdware.bdledger.api.grpc.pb.NodeGrpc;
import org.bdware.bdledger.api.grpc.pb.NodeProto;
import org.bdware.bdledger.api.grpc.pb.QueryGrpc;
import org.bdware.bdledger.api.grpc.pb.QueryProto;

public class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getName());
    private ManagedChannel channel;
    private NodeGrpc.NodeFutureStub nodeFutureStub;
    private NodeGrpc.NodeBlockingStub nodeBlockingStub;
    private LedgerGrpc.LedgerFutureStub ledgerFutureStub;
    private LedgerGrpc.LedgerBlockingStub ledgerBlockingStub;
    private QueryGrpc.QueryFutureStub queryFutureStub;
    private QueryGrpc.QueryBlockingStub queryBlockingStub;

    public Client(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(), null);
    }

    public Client(String host, int port, String token) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(), token);
    }

    public Client(ManagedChannelBuilder<?> channelBuilder, String token) {
        this.channel = channelBuilder.build();
        this.nodeFutureStub = NodeGrpc.newFutureStub((Channel)this.channel);
        this.nodeBlockingStub = NodeGrpc.newBlockingStub((Channel)this.channel);
        this.ledgerFutureStub = LedgerGrpc.newFutureStub((Channel)this.channel);
        this.ledgerBlockingStub = LedgerGrpc.newBlockingStub((Channel)this.channel);
        this.queryFutureStub = QueryGrpc.newFutureStub((Channel)this.channel);
        this.queryBlockingStub = QueryGrpc.newBlockingStub((Channel)this.channel);
        if (token != null) {
            Metadata fixedHeaders = new Metadata();
            fixedHeaders.put(Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)("bearer " + token));
            this.nodeFutureStub = GrpcHeaderInterceptor.attachHeaders(this.nodeFutureStub, fixedHeaders);
            this.nodeBlockingStub = GrpcHeaderInterceptor.attachHeaders(this.nodeBlockingStub, fixedHeaders);
            this.ledgerFutureStub = GrpcHeaderInterceptor.attachHeaders(this.ledgerFutureStub, fixedHeaders);
            this.ledgerBlockingStub = GrpcHeaderInterceptor.attachHeaders(this.ledgerBlockingStub, fixedHeaders);
            this.queryFutureStub = GrpcHeaderInterceptor.attachHeaders(this.queryFutureStub, fixedHeaders);
            this.queryBlockingStub = GrpcHeaderInterceptor.attachHeaders(this.queryBlockingStub, fixedHeaders);
        }
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public ListenableFuture<NodeProto.ClientVersionResponse> clientVersion() {
        this.info("*** clientVersion", new Object[0]);
        try {
            return this.nodeFutureStub.clientVersion(Empty.getDefaultInstance());
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public NodeProto.ClientVersionResponse clientVersionSync() {
        this.info("*** clientVersionSync", new Object[0]);
        try {
            return this.nodeBlockingStub.clientVersion(Empty.getDefaultInstance());
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    public ListenableFuture<LedgerProto.CreateLedgerResponse> createLedger(String name) {
        this.info("*** createLedger: name={0}", name);
        try {
            return this.ledgerFutureStub.createLedger(this.createLedgerRequest(name));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public LedgerProto.CreateLedgerResponse createLedgerSync(String name) {
        this.info("*** createLedgerSync: name={0}", name);
        try {
            return this.ledgerBlockingStub.createLedger(this.createLedgerRequest(name));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    private LedgerProto.CreateLedgerRequest createLedgerRequest(String name) {
        return LedgerProto.CreateLedgerRequest.newBuilder().setName(name).build();
    }

    public ListenableFuture<LedgerProto.GetLedgersResponse> getLedgers() {
        this.info("*** getLedgers", new Object[0]);
        try {
            return this.ledgerFutureStub.getLedgers(Empty.getDefaultInstance());
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public LedgerProto.GetLedgersResponse getLedgersSync() {
        this.info("*** getLedgersSync", new Object[0]);
        try {
            return this.ledgerBlockingStub.getLedgers(Empty.getDefaultInstance());
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    public ListenableFuture<LedgerProto.SendTransactionResponse> sendTransaction(String ledger, CommonProto.TransactionType type, String from, long nonce, String to, byte[] data) {
        this.info("*** sendTransaction: ledger={0} type={1} from={2} to={3} data={4}", new Object[]{ledger, type, from, to, data});
        try {
            return this.ledgerFutureStub.sendTransaction(this.SendTransactionRequest(ledger, type, from, nonce, to, data));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public LedgerProto.SendTransactionResponse sendTransactionSync(String ledger, CommonProto.TransactionType type, String from, long nonce, String to, byte[] data) {
        this.info("*** sendTransactionSync: ledger={0} type={1} from={2} to={3} data={4}", new Object[]{ledger, type, from, to, data});
        try {
            return this.ledgerBlockingStub.sendTransaction(this.SendTransactionRequest(ledger, type, from, nonce, to, data));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    private LedgerProto.SendTransactionRequest SendTransactionRequest(String ledger, CommonProto.TransactionType type, String from, long nonce, String to, byte[] data) {
        LedgerProto.SendTransactionRequest.Transaction.Builder txBuilder = LedgerProto.SendTransactionRequest.Transaction.newBuilder().setType(type);
        if (from != null) {
            txBuilder.setFrom(ByteString.copyFrom((byte[])Utils.hexStringToByteArray(from)));
        }
        txBuilder.setNonce(nonce);
        if (to != null) {
            txBuilder.setTo(ByteString.copyFrom((byte[])Utils.hexStringToByteArray(to)));
        }
        if (data != null) {
            txBuilder.setData(ByteString.copyFrom((byte[])data));
        }
        return LedgerProto.SendTransactionRequest.newBuilder().setLedger(ledger).setTransaction(txBuilder).build();
    }

    public ListenableFuture<QueryProto.GetBlockByHashResponse> getBlockByHash(String ledger, String hash, boolean fullTransactions) {
        this.info("*** getBlockByHash: ledger={0} hash={1} fullTransactions={2}", ledger, hash, fullTransactions);
        try {
            return this.queryFutureStub.getBlockByHash(this.getBlockByHashRequest(ledger, hash, fullTransactions));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public QueryProto.GetBlockByHashResponse getBlockByHashSync(String ledger, String hash, boolean fullTransactions) {
        this.info("*** getBlockByHashSync: ledger={0} hash={1} fullTransactions={2}", ledger, hash, fullTransactions);
        try {
            return this.queryBlockingStub.getBlockByHash(this.getBlockByHashRequest(ledger, hash, fullTransactions));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    private QueryProto.GetBlockByHashRequest getBlockByHashRequest(String ledger, String hash, boolean fullTransactions) {
        QueryProto.GetBlockByHashRequest.Builder reqBuilder = QueryProto.GetBlockByHashRequest.newBuilder().setLedger(ledger).setFullTransactions(fullTransactions);
        if (hash != null) {
            reqBuilder.setHash(ByteString.copyFrom((byte[])Utils.hexStringToByteArray(hash)));
        }
        return reqBuilder.build();
    }

    public ListenableFuture<QueryProto.GetBlocksResponse> getBlocks(String ledger, ZonedDateTime startDateTime, QueryProto.IncludeTransactions includeTransactions) {
        return this.getBlocks(ledger, startDateTime.toEpochSecond(), includeTransactions);
    }

    public ListenableFuture<QueryProto.GetBlocksResponse> getBlocks(String ledger, ZonedDateTime startDateTime, ZonedDateTime endDateTime, QueryProto.IncludeTransactions includeTransactions) {
        return this.getBlocks(ledger, startDateTime.toEpochSecond(), endDateTime.toEpochSecond(), includeTransactions);
    }

    public QueryProto.GetBlocksResponse getBlocksSync(String ledger, ZonedDateTime startDateTime, QueryProto.IncludeTransactions includeTransactions) {
        return this.getBlocksSync(ledger, startDateTime.toEpochSecond(), includeTransactions);
    }

    public QueryProto.GetBlocksResponse getBlocksSync(String ledger, ZonedDateTime startDateTime, ZonedDateTime endDateTime, QueryProto.IncludeTransactions includeTransactions) {
        return this.getBlocksSync(ledger, startDateTime.toEpochSecond(), endDateTime.toEpochSecond(), includeTransactions);
    }

    public ListenableFuture<QueryProto.GetBlocksResponse> getBlocks(String ledger, long startUnixTime, QueryProto.IncludeTransactions includeTransactions) {
        return this.getBlocks(ledger, startUnixTime, -1L, includeTransactions);
    }

    public ListenableFuture<QueryProto.GetBlocksResponse> getBlocks(String ledger, long startUnixTime, long endUnixTime, QueryProto.IncludeTransactions includeTransactions) {
        this.info("*** getBlocks: ledger={0} startUnixTime={1} endUnixTime={2}", ledger, startUnixTime, endUnixTime);
        try {
            return this.queryFutureStub.getBlocks(this.blocksRequest(ledger, startUnixTime, endUnixTime, includeTransactions));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public QueryProto.GetBlocksResponse getBlocksSync(String ledger, long startUnixTime, QueryProto.IncludeTransactions includeTransactions) {
        return this.getBlocksSync(ledger, startUnixTime, -1L, includeTransactions);
    }

    public QueryProto.GetBlocksResponse getBlocksSync(String ledger, long startUnixTime, long endUnixTime, QueryProto.IncludeTransactions includeTransactions) {
        this.info("*** getBlocksSync: ledger={0} startUnixTime={1} endUnixTime={2}", ledger, startUnixTime, endUnixTime);
        try {
            return this.queryBlockingStub.getBlocks(this.blocksRequest(ledger, startUnixTime, endUnixTime, includeTransactions));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    public ListenableFuture<QueryProto.CountBlocksResponse> countBlocks(String ledger) {
        this.info("*** blockNumber: ledger={0}", ledger);
        try {
            return this.queryFutureStub.countBlocks(this.blocksRequest(ledger, -1L, -1L, null));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public QueryProto.CountBlocksResponse countBlocksSync(String ledger) {
        this.info("*** blockNumberSync: ledger={0}", ledger);
        try {
            return this.queryBlockingStub.countBlocks(this.blocksRequest(ledger, -1L, -1L, null));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    private QueryProto.BlocksRequest blocksRequest(String ledger, long startTimestamp, long endTimestamp, QueryProto.IncludeTransactions includeTransactions) {
        QueryProto.BlocksRequest.Builder reqBuilder = QueryProto.BlocksRequest.newBuilder().setLedger(ledger);
        if (startTimestamp != -1L) {
            reqBuilder.setStartTimestamp(startTimestamp);
        }
        if (endTimestamp != -1L) {
            reqBuilder.setEndTimestamp(endTimestamp);
        }
        if (includeTransactions == null) {
            includeTransactions = QueryProto.IncludeTransactions.NONE;
        }
        reqBuilder.setIncludeTransactions(includeTransactions);
        return reqBuilder.build();
    }

    public ListenableFuture<QueryProto.GetBlocksResponse> getRecentBlocks(String ledger, int count, QueryProto.IncludeTransactions includeTransactions) {
        this.info("*** getRecentBlocks: ledger={0} count={1} includeTransactions={2}", new Object[]{ledger, count, includeTransactions});
        try {
            return this.queryFutureStub.getRecentBlocks(this.getRecentBlocksRequest(ledger, count, includeTransactions));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public QueryProto.GetBlocksResponse getRecentBlocksSync(String ledger, int count, QueryProto.IncludeTransactions includeTransactions) {
        this.info("*** getRecentBlocksSync: ledger={0} count={1} includeTransactions={2}", new Object[]{ledger, count, includeTransactions});
        try {
            return this.queryBlockingStub.getRecentBlocks(this.getRecentBlocksRequest(ledger, count, includeTransactions));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    private QueryProto.RecentBlocksRequest getRecentBlocksRequest(String ledger, int count, QueryProto.IncludeTransactions includeTransactions) {
        QueryProto.RecentBlocksRequest.Builder reqBuilder = QueryProto.RecentBlocksRequest.newBuilder().setLedger(ledger).setCount(count);
        if (includeTransactions == null) {
            includeTransactions = QueryProto.IncludeTransactions.NONE;
        }
        reqBuilder.setIncludeTransactions(includeTransactions);
        return reqBuilder.build();
    }

    public ListenableFuture<QueryProto.GetTransactionByHashResponse> getTransactionByHash(String ledger, String hash) {
        this.info("*** getTransactionByHash: ledger={0} hash={1}", ledger, hash);
        try {
            return this.queryFutureStub.getTransactionByHash(this.getTransactionByHashRequest(ledger, hash));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public QueryProto.GetTransactionByHashResponse getTransactionByHashSync(String ledger, String hash) {
        this.info("*** getTransactionByHashSync: ledger={0} hash={1}", ledger, hash);
        try {
            return this.queryBlockingStub.getTransactionByHash(this.getTransactionByHashRequest(ledger, hash));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    private QueryProto.GetTransactionByHashRequest getTransactionByHashRequest(String ledger, String hash) {
        QueryProto.GetTransactionByHashRequest.Builder reqBuilder = QueryProto.GetTransactionByHashRequest.newBuilder().setLedger(ledger);
        if (hash != null) {
            reqBuilder.setHash(ByteString.copyFrom((byte[])Utils.hexStringToByteArray(hash)));
        }
        return reqBuilder.build();
    }

    public ListenableFuture<QueryProto.GetTransactionByBlockHashAndIndexResponse> getTransactionByBlockHashAndIndex(String ledger, String blockHash, int index) {
        this.info("*** getTransactionByBlockHashAndIndex: ledger={0} blockHash={1} index={2}", ledger, blockHash, index);
        try {
            return this.queryFutureStub.getTransactionByBlockHashAndIndex(this.getTransactionByBlockHashAndIndexRequest(ledger, blockHash, index));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public QueryProto.GetTransactionByBlockHashAndIndexResponse getTransactionByBlockHashAndIndexSync(String ledger, String blockHash, int index) {
        this.info("*** getTransactionByBlockHashAndIndexSync: ledger={0} blockHash={1} index={2}", ledger, blockHash, index);
        try {
            return this.queryBlockingStub.getTransactionByBlockHashAndIndex(this.getTransactionByBlockHashAndIndexRequest(ledger, blockHash, index));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    private QueryProto.GetTransactionByBlockHashAndIndexRequest getTransactionByBlockHashAndIndexRequest(String ledger, String blockHash, int index) {
        QueryProto.GetTransactionByBlockHashAndIndexRequest.Builder reqBuilder = QueryProto.GetTransactionByBlockHashAndIndexRequest.newBuilder().setLedger(ledger).setIndex(index);
        if (blockHash != null) {
            reqBuilder.setBlockHash(ByteString.copyFrom((byte[])Utils.hexStringToByteArray(blockHash)));
        }
        return reqBuilder.build();
    }

    public ListenableFuture<QueryProto.GetTransactionsResponse> getTransactions(String ledger, ZonedDateTime startDateTime) {
        return this.getTransactions(ledger, startDateTime.toEpochSecond());
    }

    public ListenableFuture<QueryProto.GetTransactionsResponse> getTransactions(String ledger, ZonedDateTime startDateTime, ZonedDateTime endDateTime) {
        return this.getTransactions(ledger, startDateTime.toEpochSecond(), endDateTime.toEpochSecond());
    }

    public QueryProto.GetTransactionsResponse getTransactionsSync(String ledger, ZonedDateTime startDateTime) {
        return this.getTransactionsSync(ledger, startDateTime.toEpochSecond());
    }

    public QueryProto.GetTransactionsResponse getTransactionsSync(String ledger, ZonedDateTime startDateTime, ZonedDateTime endDateTime) {
        return this.getTransactionsSync(ledger, startDateTime.toEpochSecond(), endDateTime.toEpochSecond());
    }

    public ListenableFuture<QueryProto.GetTransactionsResponse> getTransactions(String ledger, long startUnixTime) {
        return this.getTransactions(ledger, startUnixTime, -1L);
    }

    public ListenableFuture<QueryProto.GetTransactionsResponse> getTransactions(String ledger, long startUnixTime, long endUnixTime) {
        this.info("*** getTransactions: ledger={0} startUnixTime={1} endUnixTime={2}", ledger, startUnixTime, endUnixTime);
        try {
            return this.queryFutureStub.getTransactions(this.transactionsRequest(ledger, startUnixTime, endUnixTime));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public QueryProto.GetTransactionsResponse getTransactionsSync(String ledger, long startUnixTime) {
        return this.getTransactionsSync(ledger, startUnixTime, -1L);
    }

    public QueryProto.GetTransactionsResponse getTransactionsSync(String ledger, long startUnixTime, long endUnixTime) {
        this.info("*** getTransactionsSync: ledger={0} startUnixTime={1} endUnixTime={2}", ledger, startUnixTime, endUnixTime);
        try {
            return this.queryBlockingStub.getTransactions(this.transactionsRequest(ledger, startUnixTime, endUnixTime));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    public ListenableFuture<QueryProto.CountTransactionsResponse> countTransactions(String ledger) {
        this.info("*** blockNumber: ledger={0}", ledger);
        try {
            return this.queryFutureStub.countTransactions(this.transactionsRequest(ledger, -1L, -1L));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            return null;
        }
    }

    public QueryProto.CountTransactionsResponse countTransactionsSync(String ledger) {
        this.info("*** blockNumberSync: ledger={0}", ledger);
        try {
            return this.queryBlockingStub.countTransactions(this.transactionsRequest(ledger, -1L, -1L));
        }
        catch (StatusRuntimeException e) {
            this.warning("RPC failed: {0}", e.getStatus());
            throw e;
        }
    }

    private QueryProto.TransactionsRequest transactionsRequest(String ledger, long startTimestamp, long endTimestamp) {
        QueryProto.TransactionsRequest.Builder reqBuilder = QueryProto.TransactionsRequest.newBuilder().setLedger(ledger);
        if (startTimestamp != -1L) {
            reqBuilder.setStartTimestamp(startTimestamp);
        }
        if (endTimestamp != -1L) {
            reqBuilder.setEndTimestamp(endTimestamp);
        }
        return reqBuilder.build();
    }

    private void info(String msg, Object ... params) {
        logger.log(Level.INFO, msg, params);
    }

    private void warning(String msg, Object ... params) {
        logger.log(Level.WARNING, msg, params);
    }
}

