/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.bdledger.api.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.AbstractStub;

public class GrpcHeaderInterceptor
implements ClientInterceptor {
    private final Metadata extraHeaders;

    public GrpcHeaderInterceptor(Metadata metadata) {
        this.extraHeaders = metadata;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.merge(GrpcHeaderInterceptor.this.extraHeaders);
                super.start(responseListener, headers);
            }
        };
    }

    public static <T extends AbstractStub<T>> T attachHeaders(T stub, Metadata metadata) {
        Channel channel = stub.getChannel();
        Channel interceptedChannel = ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{new GrpcHeaderInterceptor(metadata)});
        return (T)stub.withChannel(interceptedChannel);
    }
}

