/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.compiler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DiagnosticErrorListener;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.compiler.AnnotationProcessor;
import org.bdware.sc.compiler.YJSErrorListener;
import org.bdware.sc.engine.YJSFilter;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.ContractManifest;
import org.bdware.sc.node.ContractNode;
import org.bdware.sc.node.ContractZipBundle;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.node.ImportNode;
import org.bdware.sc.node.InterfaceNode;
import org.bdware.sc.parser.JavaScriptLexer;
import org.bdware.sc.parser.YJSParser;
import org.bdware.sc.util.JsonUtil;
import org.bdware.sc.visitor.ContractReader;
import wrp.jdk.nashorn.internal.objects.Global;
import wrp.jdk.nashorn.internal.runtime.Context;
import wrp.jdk.nashorn.internal.runtime.ErrorManager;
import wrp.jdk.nashorn.internal.runtime.ScriptFunction;
import wrp.jdk.nashorn.internal.runtime.Source;
import wrp.jdk.nashorn.internal.runtime.options.Options;

public class YJSCompiler {
    public boolean withProgramPointCount;
    YJSErrorListener errorListener = new YJSErrorListener();
    ContractNode contract;
    private static final Logger LOGGER = LogManager.getLogger(YJSCompiler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptFunction compileWithGlobal(Source source, Global global, Context context) {
        Global oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != global;
        try {
            if (globalChanged) {
                Context.setGlobal(global);
            }
            ScriptFunction scriptFunction = context.compileScript(source).getFunction(global);
            return scriptFunction;
        }
        catch (Exception e) {
            e.printStackTrace();
            ScriptFunction scriptFunction = null;
            return scriptFunction;
        }
        finally {
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
        }
    }

    private static Context makeContext(InputStream in, OutputStream out, OutputStream err) {
        PrintStream pout = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        PrintStream perr = err instanceof PrintStream ? (PrintStream)err : new PrintStream(err);
        PrintWriter wout = new PrintWriter(pout, true);
        PrintWriter werr = new PrintWriter(perr, true);
        ErrorManager errors = new ErrorManager(werr);
        Options options = new Options("nashorn", werr);
        options.process(new String[0]);
        options.set("persistent.code.cache", true);
        options.set("print.code", "true");
        options.set("print.parse", true);
        if (!options.getBoolean("scripting")) {
            for (String fileName : options.getFiles()) {
                File firstFile = new File(fileName);
                if (!firstFile.isFile()) continue;
                try {
                    FileReader fr = new FileReader(firstFile);
                    Throwable throwable = null;
                    try {
                        int firstChar = fr.read();
                        if (firstChar != 35) continue;
                        options.set("scripting", true);
                        break;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fr == null) continue;
                        if (throwable != null) {
                            try {
                                fr.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fr.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return new Context(options, errors, wout, werr, Thread.currentThread().getContextClassLoader(), new YJSFilter(), null);
    }

    public ContractZipBundle compile(ZipFile zf) throws Exception {
        ContractZipBundle czb = new ContractZipBundle();
        ZipEntry manifest = zf.getEntry("/manifest.json");
        if (null == manifest && null == (manifest = zf.getEntry("manifest.json"))) {
            throw new IllegalStateException("manifest.json is not exists!");
        }
        InputStream manifestInput = zf.getInputStream(manifest);
        ContractManifest cm = (ContractManifest)JsonUtil.GSON.fromJson((Reader)new InputStreamReader(manifestInput), ContractManifest.class);
        if (0L != cm.getInsnLimit()) {
            LOGGER.info("++++++++++++++++++++++true");
        }
        czb.setManifest(cm);
        HashSet<String> toParse = new HashSet<String>();
        toParse.add(cm.main);
        HashSet<String> todo = new HashSet<String>();
        HashSet<String> allEntries = new HashSet<String>();
        Enumeration<? extends ZipEntry> iter = zf.entries();
        while (iter.hasMoreElements()) {
            ZipEntry ele = iter.nextElement();
            if (ele == null) continue;
            allEntries.add(ele.getName());
        }
        while (toParse.size() > 0) {
            for (String str : toParse) {
                if (czb.containsPath(str)) continue;
                ZipEntry entry = zf.getEntry(str.startsWith("/") ? str : "/" + str);
                LOGGER.info("load yjs:" + str);
                if (null == entry) {
                    throw new IllegalStateException("missing import:" + str);
                }
                ContractNode cn = this.compile(zf.getInputStream(entry), str);
                String cnPath = entry.getName();
                int i = cnPath.lastIndexOf("/");
                String cnDir = "";
                if (i != -1) {
                    cnDir = cnPath.substring(0, i);
                }
                czb.put(str, cn);
                for (ImportNode in : cn.getImports()) {
                    String path = in.getPath();
                    if (!path.startsWith("/")) {
                        path = cnDir + "/" + path;
                    }
                    path = path.replaceAll("/\\./", "/");
                    todo.add(path);
                }
            }
            toParse.clear();
            for (String str : todo) {
                if (allEntries.contains(str)) {
                    toParse.add(str);
                    continue;
                }
                for (String entry : allEntries) {
                    if (czb.containsPath(entry) || !entry.startsWith(str) || !entry.endsWith(".yjs")) continue;
                    toParse.add(entry);
                }
            }
            todo.clear();
        }
        String preSubConName = cm.main.substring(0, cm.main.length() - 4) + "PreSub";
        String preSubContract = "contract " + preSubConName + " { function _preSub (e) { YancloudUtil.preSub(e.topic, e.content); }}";
        ContractNode preSubNode = this.compile(new ByteArrayInputStream(preSubContract.getBytes(StandardCharsets.UTF_8)), preSubConName + ".yjs");
        czb.put(preSubConName + ".yjs", preSubNode);
        LOGGER.info("--compile-- " + preSubConName);
        String globalBeanName = cm.main.substring(0, cm.main.length() - 4) + "GlobalBean";
        String globalBeanContract = "contract " + globalBeanName + "{ function setGlobal (_global) { Global = _global; }\n function getGlobal () { return Global; }}";
        czb.put(globalBeanName + ".yjs", this.compile(new ByteArrayInputStream(globalBeanContract.getBytes(StandardCharsets.UTF_8)), globalBeanName + ".yjs"));
        LOGGER.info("--compile-- " + globalBeanName);
        czb.setMergedContractNode();
        ContractNode node = czb.mergeContractNode();
        this.handleFunctionAnnotation(node);
        return czb;
    }

    public ContractNode compile(InputStream input, String fileName) throws Exception {
        JavaScriptLexer lexer = new JavaScriptLexer((CharStream)new ANTLRInputStream(input));
        lexer.setUseStrictDefault(true);
        CommonTokenStream cts = new CommonTokenStream((TokenSource)lexer);
        YJSParser parser = new YJSParser((TokenStream)cts);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        parser.addErrorListener((ANTLRErrorListener)new DiagnosticErrorListener());
        YJSParser.ProgramContext tree = parser.program();
        ContractReader reader = new ContractReader(fileName);
        this.contract = reader.visitProgram(tree);
        this.contract.initPlainText(cts);
        this.handleModuleAnnotation(this.contract);
        this.handleFunctionAnnotation(this.contract);
        return this.contract;
    }

    private void handleModuleAnnotation(ContractNode contractNode) throws Exception {
        for (AnnotationNode node : this.contract.annotations) {
            AnnotationProcessor processor = YJSCompiler.findProcessor(node);
            if (processor == null) continue;
            processor.processContract(node, contractNode);
        }
    }

    private void handleFunctionAnnotation(ContractNode contractNode) throws Exception {
        AnnotationProcessor processor;
        List annos;
        for (FunctionNode functionNode : contractNode.getFunctions()) {
            annos = functionNode.annotations;
            if (annos == null) continue;
            for (AnnotationNode anno : annos) {
                processor = YJSCompiler.findProcessor(anno);
                if (processor == null) continue;
                processor.processFunction(anno, contractNode, functionNode);
            }
        }
        for (InterfaceNode interfaceNode : contractNode.getInterfaces()) {
            annos = interfaceNode.annotations;
            if (annos == null) continue;
            for (AnnotationNode anno : annos) {
                processor = YJSCompiler.findProcessor(anno);
                if (processor == null) continue;
                processor.processInterface(anno, contractNode, interfaceNode);
            }
        }
    }

    public static AnnotationProcessor findProcessor(AnnotationNode node) {
        try {
            String clzName = YJSCompiler.class.getPackage().getName();
            clzName = clzName + ".ap." + node.getType();
            Class<?> clz = Class.forName(clzName);
            return (AnnotationProcessor)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<String> syntaxError() {
        return this.errorListener.result;
    }
}

