/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.crdt.planning;

import java.util.HashMap;
import java.util.Map;
import org.bdware.sc.crdt.planning.SharableNetworkPlanning;

public class PlanningWithkExpansivity
extends SharableNetworkPlanning {
    Map<Integer, Map<Integer, Double>> accumulationsCache;
    private final double k;
    private final double domainSize;

    public PlanningWithkExpansivity(String[] nodeIds, int[] writers, int[] readers, long maxDelay, int bandwidthDownload, int bandwidthUpload, int dataSize, double domainSize) {
        this.nodeIds = nodeIds;
        this.writers = writers;
        this.readers = readers;
        this.maxDelay = maxDelay;
        this.bandwidthDownload = bandwidthDownload;
        this.bandwidthUpload = bandwidthUpload;
        this.dataSize = dataSize;
        this.totalCountW = writers.length;
        this.totalCountR = readers.length;
        this.domainSize = domainSize;
        this.k = (domainSize - (double)dataSize) / domainSize;
    }

    @Override
    public boolean writerTreeConstraint() {
        if (this.frequencySyncW > 0.0) {
            if (this.treeDegreeW > 1.0) {
                double common = this.frequencySyncW * this.domainSize * (1.0 - Math.pow(this.k, (Math.pow(this.treeDegreeW, this.treeHeightW - 1.0) - 1.0) / (this.treeDegreeW - 1.0)));
                boolean result1 = (double)this.bandwidthDownload >= common * this.treeDegreeW;
                boolean result2 = (double)this.bandwidthUpload >= common;
                return result1 && result2;
            }
            if (this.treeDegreeW == 1.0) {
                double common = this.frequencySyncW * this.domainSize * (1.0 - Math.pow(this.k, this.treeHeightW - 1.0));
                boolean result1 = (double)this.bandwidthDownload >= common;
                boolean result2 = (double)this.bandwidthUpload >= common;
                return result1 && result2;
            }
        }
        return true;
    }

    @Override
    public boolean writer2ReaderConstraint() {
        double common = this.frequencySyncWR * this.domainSize * (1.0 - Math.pow(this.k, this.treeNodeCountW));
        boolean result1 = (double)this.bandwidthUpload >= common * this.rootCountR;
        boolean result2 = (double)this.bandwidthDownload >= common * this.rootCountW;
        return result1 && result2;
    }

    @Override
    public boolean readerTreeConstraint() {
        if (this.frequencySyncR > 0.0) {
            double common = this.frequencySyncR * this.domainSize * (1.0 - Math.pow(this.k, this.totalCountW));
            boolean result1 = (double)this.bandwidthUpload >= common * this.treeDegreeR;
            boolean result2 = (double)this.bandwidthDownload >= common;
            return result1 && result2;
        }
        return true;
    }

    double calcAccumulationWithK() {
        if (this.accumulationsCache == null) {
            this.accumulationsCache = new HashMap<Integer, Map<Integer, Double>>();
        }
        int H1 = (int)this.treeHeightW;
        int D1 = (int)this.treeDegreeW;
        if (this.accumulationsCache.get(H1) != null && this.accumulationsCache.get(H1).get(D1) != null) {
            return this.accumulationsCache.get(H1).get(D1);
        }
        double result = 0.0;
        for (int h = 1; h < H1; ++h) {
            result += Math.pow(D1, h) * (1.0 - Math.pow(this.k, (Math.pow(D1, H1 - h) - 1.0) / (double)(D1 - 1)));
        }
        this.accumulationsCache.computeIfAbsent(H1, k -> new HashMap()).put(D1, result);
        return result;
    }

    double calcAccumulation() {
        int H1 = (int)this.treeHeightW;
        double result = 0.0;
        for (int h = 1; h < H1; ++h) {
            result += 1.0 - Math.pow(this.k, H1 - h);
        }
        return result;
    }

    @Override
    public void calcOptimizedResult() {
        double a = 0.0;
        if (this.treeDegreeW > 1.0) {
            a = this.treeHeightW > 1.0 ? (this.treeHeightW - 1.0) * this.calcAccumulationWithK() * this.rootCountW : 0.0;
        } else if (this.treeDegreeW == 1.0) {
            a = this.treeHeightW > 1.0 ? (this.treeHeightW - 1.0) * this.calcAccumulation() * this.rootCountW : 0.0;
        }
        double b = this.rootCountR * this.rootCountW * (1.0 - Math.pow(this.k, this.treeNodeCountW));
        double c = this.treeHeightR > 1.0 ? (this.treeHeightR - 1.0) * (this.totalCountR - this.rootCountR) * (1.0 - Math.pow(this.k, this.totalCountW)) : 0.0;
        double A = Math.sqrt(a);
        double B = Math.sqrt(b);
        double C = Math.sqrt(c);
        this.wDelay = (long)Math.ceil((double)this.maxDelay * (A / (A + B + C)));
        this.w2rDelay = (long)Math.ceil((double)this.maxDelay * (B / (A + B + C)));
        this.rDelay = (long)Math.ceil((double)this.maxDelay * (C / (A + B + C)));
        this.frequencySyncW = this.wDelay > 0L ? (this.treeHeightW - 1.0) / (double)this.wDelay : 0.0;
        this.frequencySyncR = this.rDelay > 0L ? (this.treeHeightR - 1.0) / (double)this.rDelay : 0.0;
        this.frequencySyncWR = this.w2rDelay > 0L ? 1.0 / (double)this.w2rDelay : 0.0;
        this.totalData = (long)(this.domainSize * (this.frequencySyncW * a + this.frequencySyncWR * b + this.frequencySyncR * c));
    }
}

