/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.JsonDoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.sc.JSEngine;
import org.bdware.sc.boundry.ScriptReturnException;
import org.bdware.sc.engine.hook.ArgSchemaVisitor;
import org.bdware.sc.engine.hook.YJSAnnotation;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.ArgPacks;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.util.JsonUtil;

@YJSAnnotation(name="ResultSchema")
public class ResultSchemaHandler
implements AnnotationHook {
    private AnnotationNode a;
    private static final Logger LOGGER = LogManager.getLogger(ResultSchemaHandler.class);

    public ResultSchemaHandler(AnnotationNode annotationNode) {
        this.a = annotationNode;
    }

    public ArgPacks handle(JSEngine desktopEngine, ArgPacks argPacks) throws ScriptReturnException {
        Object ret = argPacks.ret;
        if (ret != null) {
            JsonObject jo;
            ArgSchemaVisitor visitor;
            JsonDoipMessage jo2;
            JsonElement je = null;
            if (ret instanceof DoipMessage) {
                jo2 = JsonDoipMessage.fromDoipMessage((DoipMessage)((DoipMessage)ret));
                je = JsonUtil.parseObjectAsJsonObject((Object)jo2);
            } else if (ret instanceof JsonElement) {
                je = (JsonElement)ret;
            }
            if (je == null) {
                jo2 = new JsonObject();
                jo2.addProperty("msg", "[Illegal Type] result should not be empty or null");
                jo2.addProperty("code", (Number)1004);
                throw new ScriptReturnException((JsonElement)jo2);
            }
            if (je.isJsonObject()) {
                visitor = new ArgSchemaVisitor((JsonElement)je.getAsJsonObject());
            } else {
                try {
                    JsonElement obj = JsonParser.parseString((String)je.getAsString());
                    visitor = new ArgSchemaVisitor(obj);
                    argPacks.ret = obj;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JsonObject jo3 = new JsonObject();
                    jo3.addProperty("msg", "[Illegal Type] result should be JSON");
                    jo3.add("errorResult", je);
                    jo3.addProperty("code", (Number)1004);
                    throw new ScriptReturnException((JsonElement)jo3);
                }
            }
            if (je.toString().isEmpty() && !((String)this.a.getArgs().get(0)).equals("")) {
                jo = new JsonObject();
                jo.addProperty("msg", "[Empty result] result should not be empty");
                jo.addProperty("code", (Number)1003);
                throw new ScriptReturnException((JsonElement)jo);
            }
            visitor.visit(JsonParser.parseString((String)((String)this.a.getArgs().get(0))));
            if (!visitor.getStatus()) {
                jo = new JsonObject();
                jo.addProperty("msg", visitor.getException());
                jo.addProperty("code", (Number)visitor.errorCode);
                jo.add("errorResult", je);
                jo.add("resultSchema", JsonParser.parseString((String)((String)this.a.getArgs().get(0))));
                throw new ScriptReturnException((JsonElement)jo);
            }
        }
        return argPacks;
    }

    public static ResultSchemaHandler fromAnnotationNode(FunctionNode funNode, AnnotationNode annoNode) {
        return new ResultSchemaHandler(annoNode);
    }
}

