/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.security.interfaces.RSAPublicKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractResult;
import org.bdware.sc.JSEngine;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.boundry.JavaScriptEntry;
import org.bdware.sc.engine.hook.HomoVisitor;
import org.bdware.sc.engine.hook.ObjToJsonHandler;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.util.JsonUtil;
import org.paillier.PaillierKeyPair;

public class HomomorphicEncryptHandler
implements AnnotationHook {
    private static final Logger LOGGER = LogManager.getLogger(ObjToJsonHandler.class);
    private final FunctionNode fun;

    public HomomorphicEncryptHandler(FunctionNode fun) {
        this.fun = fun;
    }

    public Object handle(ContractRequest input, JSEngine engine, Object ret) {
        try {
            LOGGER.info("HomomorphicEncryptHandler--------------------------------1: " + input.getRequester());
            LOGGER.info("HomomorphicEncryptHandler--------------------------------2: " + this.fun.getSecretID());
            JsonElement response = (JsonElement)ret;
            JsonElement homoEncryptConf = this.fun.getHomoEncryptConf();
            if (homoEncryptConf != null && !homoEncryptConf.isJsonNull()) {
                String res = (String)JavaScriptEntry.executeContract("keyManager_1", "getPubKey", this.fun.getSecretID().replaceAll("\"", ""));
                LOGGER.info("HomomorphicEncryptHandler--------------------------------4: " + res);
                ContractResult results = (ContractResult)JsonUtil.fromJson((String)res, ContractResult.class);
                String pubKeyStr = results.result.getAsString();
                LOGGER.info("HomomorphicEncryptHandler--------------------------------5: " + pubKeyStr);
                HomoVisitor.publicKey = (RSAPublicKey)PaillierKeyPair.pemToPublicKey((String)pubKeyStr);
                LOGGER.info("HomomorphicEncryptHandler--------------------------------6: " + homoEncryptConf);
                LOGGER.info("HomomorphicEncryptHandler--------------------------------7: " + ret);
                LOGGER.info("HomomorphicEncryptHandler--------------------------------8: " + ret.toString());
                ret = this.getEncryptResult(homoEncryptConf, response);
                if (ret != null) {
                    return ret;
                }
                ret = new JsonObject();
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    private Object getEncryptResult(JsonElement homoEncryptConf, JsonElement data) {
        if (null == homoEncryptConf) {
            return data;
        }
        HomoVisitor visitor = new HomoVisitor(data);
        visitor.visit(homoEncryptConf);
        JsonElement root = visitor.get();
        System.out.println("HomoRetInvoke: " + root);
        LOGGER.info("HomoRetInvoke: " + root);
        return root;
    }
}

