/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.alibaba.datax.transport.transformer.maskingMethods.cryptology.AESEncryptionImpl;
import com.alibaba.datax.transport.transformer.maskingMethods.cryptology.FormatPreservingEncryptionImpl;
import com.alibaba.datax.transport.transformer.maskingMethods.differentialPrivacy.EpsilonDifferentialPrivacyImpl;
import com.alibaba.datax.transport.transformer.maskingMethods.irreversibleInterference.MD5EncryptionImpl;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.bdware.mockjava.JsonVisitor;

public class MaskVisitor
extends JsonVisitor {
    JsonElement root;

    public MaskVisitor(JsonElement ret) {
        this.root = ret;
    }

    public JsonVisitor visitObject(JsonObject mask) {
        if (this.root.isJsonObject()) {
            JsonObject jo = this.root.getAsJsonObject();
            for (String key : mask.keySet()) {
                if (!jo.has(key)) continue;
                MaskVisitor visitor = new MaskVisitor(jo.get(key));
                visitor.visit(mask.get(key));
                jo.add(key, visitor.get());
            }
        }
        return this;
    }

    public JsonVisitor visitJsonArray(JsonArray ele) {
        if (this.root.isJsonArray()) {
            JsonArray array = this.root.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                MaskVisitor visitor = new MaskVisitor(array.get(i));
                visitor.visit(ele.get(0));
                array.set(i, visitor.get());
            }
        }
        return this;
    }

    public JsonElement get() {
        return this.root;
    }

    public JsonVisitor visitPrimitive(JsonPrimitive primitive) {
        if (primitive.isString()) {
            String method = primitive.getAsString();
            try {
                String result = "";
                if (method.equals("md5")) {
                    MD5EncryptionImpl masker = new MD5EncryptionImpl();
                    result = masker.execute(this.root.getAsString());
                } else if (method.equals("aes")) {
                    AESEncryptionImpl masker = new AESEncryptionImpl();
                    result = masker.execute(this.root.getAsString());
                } else if (method.equals("fpe")) {
                    FormatPreservingEncryptionImpl masker = new FormatPreservingEncryptionImpl();
                    result = masker.execute(this.root.getAsString());
                } else if (method.equals("edp")) {
                    EpsilonDifferentialPrivacyImpl masker = new EpsilonDifferentialPrivacyImpl();
                    double epsilon = 1.0;
                    result = "" + masker.maskOne(this.root.getAsDouble(), epsilon);
                } else {
                    result = this.root.getAsString();
                }
                System.out.println(result);
                this.root = new JsonPrimitive(result);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return this;
    }
}

