/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.boundry;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bdware.sc.boundry.TimeIndex;
import org.bdware.sc.index.LenVarTimeSerialIndex2;
import org.bdware.sc.util.HashUtil;
import wrp.jdk.nashorn.api.scripting.ScriptObjectMirror;
import wrp.jdk.nashorn.internal.objects.Global;
import wrp.jdk.nashorn.internal.objects.NativeArray;
import wrp.jdk.nashorn.internal.runtime.PropertyMap;
import wrp.jdk.nashorn.internal.runtime.ScriptObject;
import wrp.jdk.nashorn.internal.scripts.JO;

public class AccountIndex {
    static Map<String, LenVarTimeSerialIndex2> fileMap = new HashMap<String, LenVarTimeSerialIndex2>();

    public static AccountIndex createIndex() {
        return new AccountIndex();
    }

    private static String getString(ScriptObjectMirror obj, String member) {
        Object mem = obj.getMember(member);
        if (mem != null && !(mem instanceof String)) {
            return mem.toString();
        }
        return (String)mem;
    }

    private static Integer getInteger(ScriptObjectMirror obj, String member) {
        Object mem = obj.getMember(member);
        if (mem != null && !(mem instanceof Integer)) {
            return Integer.valueOf(mem.toString());
        }
        return (Integer)mem;
    }

    private static Long getLong(ScriptObjectMirror obj, String member) {
        Object mem = obj.getMember(member);
        if (mem != null && !(mem instanceof Long)) {
            return Long.valueOf(mem.toString());
        }
        return (Long)mem;
    }

    public ScriptObject createFile(ScriptObjectMirror args) {
        JO ret = new JO(PropertyMap.newMap());
        if (!args.hasMember("account")) {
            ret.put((Object)"result", (Object)"Missing Argumemt", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        if (!args.hasMember("file")) {
            ret.put((Object)"result", (Object)"Missing Argumemt", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        if (!args.hasMember("dataLength")) {
            ret.put((Object)"result", (Object)"Missing Argumemt", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        try {
            Object file = args.get((Object)"file");
            if (!(file instanceof String)) {
                ret.put((Object)"result", (Object)"Illegal Type, file is not String", false);
                ret.put((Object)"status", (Object)"Error", false);
                return ret;
            }
            Object address = args.get((Object)"account");
            if (!(address instanceof String)) {
                ret.put((Object)"result", (Object)"Illegal Type, file is not String", false);
                ret.put((Object)"status", (Object)"Error", false);
                return ret;
            }
            String fileName = "./" + address + file;
            File f = new File(fileName + ".datasize");
            FileOutputStream fout = new FileOutputStream(f, false);
            Object dataLength = args.get((Object)"dataLength");
            int dataLengthInt = Integer.parseInt(dataLength.toString());
            for (int i = 0; i < dataLengthInt; ++i) {
                fout.write(1);
            }
            fout.close();
            LenVarTimeSerialIndex2 index = this.getIndexFile(fileName);
            ret.put((Object)"dataLength", dataLength, false);
            ret.put((Object)"datasize", (Object)f.length(), false);
            ret.put((Object)"status", (Object)"Success", false);
            return ret;
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            ret.put((Object)"status", (Object)"Success", false);
            ret.put((Object)"result", (Object)bo.toString(), false);
            return ret;
        }
    }

    public ScriptObject requestByTime(ScriptObjectMirror args) {
        JO ret = new JO(PropertyMap.newMap());
        if (!args.hasMember("account")) {
            ret.put((Object)"result", (Object)"Missing Argumemt", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        if (!args.hasMember("file")) {
            ret.put((Object)"result", (Object)"Missing Argumemt: file", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        if (!args.hasMember("startTime")) {
            ret.put((Object)"result", (Object)"Missing Argumemt: startTime", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        if (!args.hasMember("endTime")) {
            ret.put((Object)"result", (Object)"Missing Argumemt: endTime", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        try {
            LenVarTimeSerialIndex2 index = this.getIndexFile(AccountIndex.getString(args, "account") + AccountIndex.getString(args, "file"));
            long startTime = AccountIndex.getLong(args, "startTime");
            long endTime = AccountIndex.getLong(args, "endTime");
            List result = index.requestByTime(startTime, endTime);
            ret.put((Object)"status", (Object)"Success", false);
            NativeArray array = Global.allocate((int[])new int[0]);
            ret.put((Object)"list", (Object)array, false);
            for (byte[] bytes : result) {
                JO data = new JO(PropertyMap.newMap());
                TimeIndex.Data d = new TimeIndex.Data(bytes);
                data.put((Object)"data", (Object)d.data, false);
                data.put((Object)"date", (Object)d.date, false);
                NativeArray.push((Object)array, (Object)data);
            }
            return ret;
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            ret.put((Object)"status", (Object)"Error", false);
            ret.put((Object)"data", (Object)bo.toString(), false);
            return ret;
        }
    }

    private LenVarTimeSerialIndex2 getIndexFile(String str) {
        LenVarTimeSerialIndex2 indexFile = fileMap.get(str);
        if (indexFile == null) {
            indexFile = new LenVarTimeSerialIndex2(str);
            fileMap.put(str, indexFile);
        }
        return indexFile;
    }

    public ScriptObject manullyIndex(ScriptObjectMirror args) {
        JO ret = new JO(PropertyMap.newMap());
        if (!args.hasMember("account")) {
            ret.put((Object)"result", (Object)"Missing Argumemt: account", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        if (!args.hasMember("date")) {
            ret.put((Object)"result", (Object)"Missing Argumemt: date", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        if (!args.hasMember("content")) {
            ret.put((Object)"result", (Object)"Missing Argumemt: content", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        if (!args.hasMember("file")) {
            ret.put((Object)"result", (Object)"Missing Argumemt: file", false);
            ret.put((Object)"status", (Object)"Error", false);
            return ret;
        }
        try {
            LenVarTimeSerialIndex2 index = this.getIndexFile(AccountIndex.getString(args, "account") + AccountIndex.getString(args, "file"));
            long date = AccountIndex.getLong(args, "date");
            String content = AccountIndex.getString(args, "content");
            index.manullyIndex(date, HashUtil.str16ToBytes((String)content));
            ret.put((Object)"status", (Object)"Success", false);
            return ret;
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            ret.put((Object)"status", (Object)"Error", false);
            ret.put((Object)"data", (Object)bo.toString(), false);
            return ret;
        }
    }
}

