/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.boundry.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.compiler.PermissionStub;
import org.bdware.sc.node.Permission;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import wrp.jdk.nashorn.internal.runtime.PropertyMap;
import wrp.jdk.nashorn.internal.runtime.ScriptObject;
import wrp.jdk.nashorn.internal.scripts.JO;

@PermissionStub(permission=Permission.RocksDB)
public class RocksDBUtil {
    private static final Logger LOGGER = LogManager.getLogger(RocksDBUtil.class);
    static Map<String, RocksDBUtil> cacheDB = new HashMap<String, RocksDBUtil>();
    RocksDB rocksDB;
    String path;

    public RocksDBUtil(String path, boolean readOnly) {
        try {
            this.path = path;
            Options options = new Options();
            options.setCreateIfMissing(true);
            File parent = new File("./ContractDB/" + ContractProcess.getContractDir());
            File dir = new File(parent, path);
            if (!dir.exists()) {
                LOGGER.info("create directory " + dir.getAbsolutePath() + ": " + dir.mkdirs());
            }
            File lockFile = new File(dir, "LOCK");
            this.rocksDB = readOnly ? RocksDB.openReadOnly((Options)options, (String)dir.getAbsolutePath()) : RocksDB.open((Options)options, (String)dir.getAbsolutePath());
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
    }

    public static RocksDBUtil loadDB(String path, boolean readOnly) {
        if (cacheDB.containsKey(path)) {
            return cacheDB.get(path);
        }
        RocksDBUtil ret = new RocksDBUtil(path, readOnly);
        cacheDB.put(path, ret);
        return ret;
    }

    public static RocksDBUtil loadDB(String path, String readOnly) {
        return RocksDBUtil.loadDB(path, Boolean.parseBoolean(readOnly));
    }

    public void close() {
        this.rocksDB.close();
        cacheDB.remove(this.path);
    }

    public String get(String key) {
        try {
            return new String(this.rocksDB.get(key.getBytes()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long estimateKeySize() {
        try {
            return this.rocksDB.getLongProperty("rocksdb.estimate-num-keys");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void put(String key, String value) {
        try {
            this.rocksDB.put(key.getBytes(), value.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String delete(String key) {
        try {
            this.rocksDB.delete(key.getBytes());
            return "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "failed";
        }
    }

    public RocksIterator newIterator() {
        try {
            return this.rocksDB.newIterator();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ScriptObject getNext(RocksIterator iter) {
        if (iter.isValid()) {
            JO ret = new JO(PropertyMap.newMap());
            ret.put((Object)"key", (Object)new String(iter.key()), false);
            ret.put((Object)"value", (Object)new String(iter.value()), false);
            iter.next();
            return ret;
        }
        return null;
    }

    static {
        RocksDB.loadLibrary();
    }
}

