/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.debugger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.client.SmartContractClient;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.bean.Contract;
import org.bdware.sc.bean.ContractExecType;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.get.GetMessage;
import org.bdware.sc.http.HttpUtil;
import org.bdware.sc.util.FileUtil;
import org.bdware.sc.util.JsonUtil;
import org.zz.gmhelper.SM2KeyPair;

public class DebugMain {
    static Logger LOGGER = LogManager.getLogger(DebugMain.class);

    public static void main(String[] args) {
        String content = FileUtil.getFileContent((String)"./debugconf.json");
        DebugConfig config = (DebugConfig)JsonUtil.fromJson((String)content, DebugConfig.class);
        DebugMain.inject(config);
        String keyPairStr = "{\"publicKey\":\"%s\",\"privateKey\":\"%s\"}";
        SM2KeyPair pair = SM2KeyPair.fromJson((String)String.format(keyPairStr, config.pubKey, config.privKey));
        String uriFormat = "ws://%s/SCIDE/SCExecutor";
        if (config.killContract != null && config.killContract.length() > 0) {
            SmartContractClient client = new SmartContractClient(String.format(uriFormat, config.agentHttpAddr), pair);
            client.waitForConnect();
            client.login();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            client.sendMsg("{\"action\":\"killContractProcess\",\"contractName\":\"" + config.killContract + "\"}");
        }
        config.contract.setCreateParam(config.createParam);
        ContractProcess.main(new String[]{"-port=" + config.port, "-cmi=" + config.cmi, "-disablePID"});
        ResultCallback printCallback = new ResultCallback(){

            public void onResult(String str) {
                LOGGER.info(str);
            }
        };
        ContractProcess.instance.handler.setDBInfo(DebugMain.wrap("", config.dbPath), printCallback);
        ContractProcess.instance.handler.registerMangerPort(DebugMain.wrap("", config.cPort), printCallback);
        ContractProcess.instance.handler.setContractBundle(DebugMain.wrap("", config.contract), printCallback);
        String urlFormat = "http://%s/SCIDE/SCManager?action=reconnectPort&owner=%s&port=%d";
        String url = String.format(urlFormat, config.agentHttpAddr, config.pubKey, ContractProcess.instance.server.mainPort.get());
        Map resp = HttpUtil.httpGet((String)url);
        String data = (String)resp.get("response");
        LOGGER.info("start done!");
    }

    private static void inject(DebugConfig config) {
        Contract contract;
        String urlFormat = "http://%s/SCIDE/SCManager?action=%s&arg=%s";
        String url = String.format(urlFormat, config.agentHttpAddr, "getAgentConfig", "");
        Map resp = HttpUtil.httpGet((String)url);
        String data = (String)resp.get("response");
        JsonObject jsonObject = JsonUtil.parseStringAsJsonObject((String)data);
        config.cmi = jsonObject.get("cmi").getAsString();
        config.dbPath = jsonObject.get("dbPath").getAsString();
        config.cPort = jsonObject.get("cPort").getAsInt();
        config.port = jsonObject.get("port").getAsInt();
        JsonObject ownerAndScript = new JsonObject();
        String arg = "abc&owner=" + config.pubKey + "&script=" + config.script;
        url = String.format(urlFormat, config.agentHttpAddr, "allocateKeyPair", arg);
        resp = HttpUtil.httpGet((String)url);
        LOGGER.info(url);
        String contractStr = (String)resp.get("response");
        LOGGER.info("[ContratStr] " + contractStr);
        config.contract = contract = (Contract)JsonUtil.fromJson((String)contractStr, Contract.class);
        contract.setType(ContractExecType.Sole);
    }

    private static GetMessage wrap(String operation, Object arg) {
        return DebugMain.wrap(operation, JsonUtil.toJson((Object)arg));
    }

    private static GetMessage wrap(String operation, String arg) {
        GetMessage msg = new GetMessage();
        msg.method = operation;
        msg.arg = arg;
        return msg;
    }

    static class DebugConfig {
        String killContract;
        public JsonElement createParam;
        String script;
        String agentHttpAddr;
        String pubKey;
        String privKey;
        int port;
        String cmi;
        String dbPath;
        int cPort;
        Contract contract;

        DebugConfig() {
        }
    }
}

