/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.trace;

import java.io.PrintStream;
import java.util.Set;
import wrp.jdk.nashorn.internal.runtime.ScriptObject;
import wrp.jdk.nashorn.internal.runtime.ScriptRuntime;
import wrp.jdk.nashorn.internal.runtime.TraceMethod;

public class MethodInvokePrinter
implements TraceMethod {
    PrintStream out;

    public void printObject(Object arg) {
        if (arg instanceof ScriptObject) {
            ScriptObject object = (ScriptObject)arg;
            boolean isFirst = true;
            Set keySet = object.keySet();
            if (keySet.isEmpty()) {
                this.out.print(ScriptRuntime.safeToString((Object)arg));
            } else {
                this.out.print("{ ");
                for (Object key : keySet) {
                    if (!isFirst) {
                        this.out.print(", ");
                    }
                    this.out.print(key);
                    this.out.print(":");
                    Object value = object.get(key);
                    if (value instanceof ScriptObject) {
                        this.out.print("...");
                    } else {
                        this.printObject(value);
                    }
                    isFirst = false;
                }
                this.out.print(" }");
            }
        } else {
            this.out.print(ScriptRuntime.safeToString((Object)arg));
        }
    }

    public void tracePrint(String tag, int pc, String methodName, Object[] args, Object result) {
        this.out.print(tag);
        this.out.print(methodName + "_" + pc + "(");
        if (args.length > 0) {
            this.printObject(args[0]);
            for (int i = 1; i < args.length; ++i) {
                Object arg = args[i];
                this.out.print(", ");
                if (!(arg instanceof ScriptObject) || !((ScriptObject)arg).isScope()) {
                    this.printObject(arg);
                    continue;
                }
                this.out.print("SCOPE");
            }
        }
        this.out.print(")");
        if (tag.equals("EXIT  ")) {
            this.out.print(" --> ");
            this.printObject(result);
        }
        this.out.println();
    }
}

