/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.trace;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.bdware.analysis.CFGraph;
import org.bdware.sc.ContractProcess;
import wrp.jdk.nashorn.internal.runtime.TraceMethod;

public class ProgramPointCounter
extends ContractProcess.Logger
implements TraceMethod {
    public long gasLimit;
    public long extraGas;
    ByteArrayOutputStream bo;
    HashMap<Integer, Map<String, Integer>> ppc = new HashMap();
    String globalAction;
    HashMap<String, CFGraph> cfgMap;
    HashMap<String, Long> countMap;
    int functionIndex = 0;
    public long gasValue = 0L;
    boolean simple = true;
    boolean initEnter = false;
    Stack<Integer> pcStack = new Stack();
    public long cost = 0L;

    public ProgramPointCounter(ByteArrayOutputStream bo, ContractProcess cp, long gasLimit, int functionIndex, long gasValue, long extraGas, String action, HashMap<String, Long> countMap) {
        super((OutputStream)new PrintStream(bo), cp);
        this.bo = bo;
        this.globalAction = action;
        this.gasLimit = gasLimit - extraGas;
        this.functionIndex = functionIndex;
        this.countMap = countMap;
        this.gasValue = gasValue - extraGas;
        this.extraGas = extraGas;
    }

    @Override
    public String getOutputStr() {
        return this.bo.toString();
    }

    public void tracePrint(String tag, int pc, String methodName, Object[] args, Object result) {
        if (!this.initEnter) {
            this.compareValue(String.valueOf(this.functionIndex));
            this.initEnter = true;
        }
        if (tag.equals("EXIT  ")) {
            if (pc == this.pcStack.peek()) {
                this.pcStack.pop();
                if (this.countMap.containsKey(String.valueOf(pc))) {
                    this.compareValue(String.valueOf(pc));
                }
            }
        } else {
            this.pcStack.push(pc);
        }
    }

    private void compareValue(String index) {
        if (this.gasValue > this.gasLimit) {
            System.out.println("out of gas");
            throw new IllegalStateException("gas out of limit");
        }
        this.cost += this.countMap.get(index).longValue();
        this.gasValue -= this.countMap.get(index).longValue();
        this.gasLimit -= this.countMap.get(index).longValue();
        if (this.gasValue <= 0L) {
            System.out.println("out of gas");
            throw new IllegalStateException("run out of InsnFee");
        }
        if (this.gasLimit <= 0L) {
            System.out.println("out of gas");
            throw new IllegalStateException("run over the limit");
        }
    }

    @Override
    public void println(String s) {
        super.println(s);
        JsonObject jo = new JsonParser().parse(s).getAsJsonObject();
        String traceMarkValue = jo.get("traceMark").getAsString();
        String val = jo.get("val").getAsString();
        for (Map.Entry<String, Long> test : this.countMap.entrySet()) {
            if (!test.getKey().contains(traceMarkValue)) continue;
            if (Integer.valueOf(val) <= 0 && test.getKey().contains("false")) {
                this.compareValue(test.getKey());
                continue;
            }
            if (Integer.valueOf(val) <= 0 || !test.getKey().contains("true")) continue;
            this.compareValue(test.getKey());
        }
    }
}

