/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.trace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jdk.internal.dynalink.CallSiteDescriptor;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.engine.SyncMechUtil;
import org.bdware.sc.trace.JS;
import org.bdware.sc.trace.JSArray;
import org.bdware.sc.trace.JSNull;
import org.bdware.sc.trace.JSObject;
import org.bdware.sc.trace.JSScript;
import org.bdware.sc.trace.JSUndifined;
import org.bdware.sc.trace.TraceDone;
import org.bdware.sc.trace.TraceInitArray;
import org.bdware.sc.trace.TraceRecord;
import org.bdware.sc.trace.TraceSet;
import org.bdware.sc.trace.TraceSetIdentifier;
import org.bdware.sc.trace.TraceSetup;
import wrp.jdk.nashorn.internal.objects.NativeArray;
import wrp.jdk.nashorn.internal.runtime.ConsString;
import wrp.jdk.nashorn.internal.runtime.Context;
import wrp.jdk.nashorn.internal.runtime.JSType;
import wrp.jdk.nashorn.internal.runtime.PropertyMap;
import wrp.jdk.nashorn.internal.runtime.ScriptObject;
import wrp.jdk.nashorn.internal.runtime.TraceSetBehavior;
import wrp.jdk.nashorn.internal.runtime.TraceSetupArray;
import wrp.jdk.nashorn.internal.runtime.TraceSetupScriptObject;
import wrp.jdk.nashorn.internal.runtime.Undefined;
import wrp.jdk.nashorn.internal.runtime.arrays.ArrayData;

public class TraceRecordUtil {
    SyncMechUtil syncUtil;
    DesktopEngine engine;
    public ArrayList<TraceRecord> traceRecords;
    public TraceRecord currentTraceRecord;
    public Map<Integer, TraceInitArray> currentArrayMap;
    public Map<TraceSetIdentifier, TraceSet> currentMap;

    public TraceRecordUtil(DesktopEngine de, SyncMechUtil sync) {
        this.engine = de;
        this.syncUtil = sync;
    }

    public ArrayList<TraceRecord> getTraceRecords() {
        if (this.traceRecords == null) {
            return null;
        }
        return this.traceRecords;
    }

    public TraceRecord getTraceRecord(int c) {
        if (this.traceRecords == null) {
            return null;
        }
        if (this.traceRecords.size() <= c) {
            return null;
        }
        return this.traceRecords.get(c);
    }

    public String getTraceRecordsContent() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.traceRecords.size(); ++i) {
            str.append("No." + i + "record : \n" + this.traceRecords.get(i).toString());
        }
        return str.toString();
    }

    public static String getTraceRecordsByFile(String fileName) {
        ArrayList traceRecords = null;
        File file = new File(fileName);
        try {
            FileInputStream fileout = new FileInputStream(file);
            GZIPInputStream gzin = new GZIPInputStream(fileout);
            ObjectInputStream reader = new ObjectInputStream(gzin);
            traceRecords = (ArrayList)reader.readObject();
            reader.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < traceRecords.size(); ++i) {
            str.append("No." + i + "record : \n" + ((TraceRecord)traceRecords.get(i)).toString());
        }
        return str.toString();
    }

    public void addSmpSet() {
        this.currentTraceRecord.traces.addAll(this.currentArrayMap.values());
        this.currentTraceRecord.traces.addAll(this.currentMap.values());
    }

    public void saveTraceRecords(String fileName) {
        File traceFile;
        File parent;
        if (this.traceRecords == null) {
            System.out.println("[saveTraceRecords] traceRecords is null,can't save traceRecords to fill!");
        }
        if (!(parent = (traceFile = new File(fileName + ".trace")).getParentFile()).exists()) {
            parent.mkdirs();
        }
        try {
            FileOutputStream fileout = new FileOutputStream(traceFile);
            GZIPOutputStream out = new GZIPOutputStream(fileout);
            ObjectOutputStream writer = new ObjectOutputStream(out);
            writer.writeObject(this.traceRecords);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startRecordTrace() {
        this.traceRecords = new ArrayList();
        Context.TRACESETBEHAVIOR = new TraceSetBehavior(){

            public void trace(CallSiteDescriptor desc, Object ... args) {
                int id = ((ScriptObject)args[0]).getObjectID();
                Object key = null;
                Object value = null;
                if (args.length == 3) {
                    key = JSType.toPrimitive((Object)args[1]);
                    value = args[2];
                } else if (args.length == 2) {
                    key = desc.getName().split(":")[2];
                    value = args[1];
                }
                if (!(value instanceof Integer || value instanceof String || value instanceof Double)) {
                    value = value instanceof ConsString ? value.toString() : TraceRecordUtil.produceJS(value);
                }
                TraceRecordUtil.this.currentMap.put(new TraceSetIdentifier(id, key), new TraceSet(id, key, value));
            }
        };
        Context.TRACESETUPSCRIPTOBJECT = new TraceSetupScriptObject(){

            public void trace(ScriptObject arg, PropertyMap map) {
                TraceSetup tracesetup = new TraceSetup((JSScript)TraceRecordUtil.produceJS(arg));
                TraceRecordUtil.this.currentTraceRecord.record(tracesetup);
            }
        };
        Context.TRACESETUPARRAY = new TraceSetupArray(){

            public void trace(ArrayData arg, int id) {
                TraceInitArray traceinitarray = new TraceInitArray(id);
                int i = 0;
                while ((long)i < arg.length()) {
                    Object obj = arg.getObject(i);
                    if (!(obj instanceof Integer || obj instanceof String || obj instanceof Double)) {
                        obj = obj instanceof ConsString ? obj.toString() : TraceRecordUtil.produceJS(obj);
                    }
                    traceinitarray.put(i, obj);
                    ++i;
                }
                TraceRecordUtil.this.currentArrayMap.put(traceinitarray.getArrayId(), traceinitarray);
            }
        };
    }

    public void stopRecordTrace() {
        Context.TRACESETBEHAVIOR = null;
        Context.TRACESETUPARRAY = null;
        Context.TRACESETUPSCRIPTOBJECT = null;
    }

    public static JS produceJS(Object arg) {
        if (arg == null) {
            return new JSNull();
        }
        if (arg instanceof NativeArray) {
            JSArray arr = new JSArray(((ScriptObject)arg).getObjectID());
            return arr;
        }
        if (arg instanceof ScriptObject) {
            JSObject obj = new JSObject(((ScriptObject)arg).getObjectID());
            return obj;
        }
        if (arg instanceof Undefined) {
            return new JSUndifined();
        }
        System.out.println("[produceJS] arg encounter new type!" + arg.toString() + " " + arg.getClass());
        return new JS();
    }

    public void startNext() {
        this.currentTraceRecord = new TraceRecord();
        this.currentArrayMap = new LinkedHashMap<Integer, TraceInitArray>();
        this.currentMap = new LinkedHashMap<TraceSetIdentifier, TraceSet>();
    }

    public void eachFinish() {
        this.addSmpSet();
        this.currentTraceRecord.record(new TraceDone(ScriptObject.getAllocID()));
        this.traceRecords.add(this.currentTraceRecord);
    }
}

