/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.trace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.script.Bindings;
import org.bdware.sc.boundry.JavaScriptEntry;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.trace.JSArray;
import org.bdware.sc.trace.JSNull;
import org.bdware.sc.trace.JSObject;
import org.bdware.sc.trace.JSUndifined;
import org.bdware.sc.trace.Trace;
import org.bdware.sc.trace.TraceDone;
import org.bdware.sc.trace.TraceInitArray;
import org.bdware.sc.trace.TraceInitObject;
import org.bdware.sc.trace.TraceRecord;
import org.bdware.sc.trace.TraceSet;
import org.bdware.sc.trace.TraceSetup;
import wrp.jdk.nashorn.api.scripting.NashornScriptEngine;
import wrp.jdk.nashorn.api.scripting.ScriptObjectMirror;
import wrp.jdk.nashorn.internal.objects.Global;
import wrp.jdk.nashorn.internal.runtime.Context;
import wrp.jdk.nashorn.internal.runtime.ScriptFunction;
import wrp.jdk.nashorn.internal.runtime.ScriptObject;
import wrp.jdk.nashorn.internal.scripts.JO;

public class TraceRecoverUtil {
    DesktopEngine engine;
    NashornScriptEngine nashornEngine;
    private ArrayList<TraceRecord> traceRecords;
    private int recoverFlag;
    private Map<Integer, ScriptObjectMirror> recoverMap;

    public TraceRecoverUtil(DesktopEngine de) {
        this.engine = de;
        this.recoverFlag = -1;
        this.nashornEngine = this.engine.getNashornEngine();
    }

    public Map<Integer, ScriptObjectMirror> getMap() {
        return this.recoverMap;
    }

    public ArrayList<TraceRecord> getTraceRecords() {
        if (this.traceRecords == null) {
            return null;
        }
        return this.traceRecords;
    }

    public TraceRecord getTraceRecord(int c) {
        if (this.traceRecords == null) {
            return null;
        }
        if (this.traceRecords.size() <= c) {
            return null;
        }
        return this.traceRecords.get(c);
    }

    public String getTraceRecordsContent() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.traceRecords.size(); ++i) {
            str.append("No." + i + "record : \n" + this.traceRecords.get(i).toString());
        }
        return str.toString();
    }

    public void setTraceRecords(String fileName) {
        File file = new File(fileName);
        try {
            FileInputStream fileout = new FileInputStream(file);
            GZIPInputStream gzin = new GZIPInputStream(fileout);
            ObjectInputStream reader = new ObjectInputStream(gzin);
            this.traceRecords = (ArrayList)reader.readObject();
            reader.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void recoverInit() {
        this.recoverMap = new HashMap<Integer, ScriptObjectMirror>();
        Bindings bindings = this.nashornEngine.getBindings(100);
        System.out.println(bindings);
        for (String key : bindings.keySet()) {
            Object obj = bindings.get(key);
            if (!(obj instanceof ScriptObjectMirror)) continue;
            this.initRecoverMap((ScriptObjectMirror)obj);
        }
        Context.setGlobal((Global)JavaScriptEntry.getEngineGlobal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recoverFromTraceRecord() {
        System.out.println("[TraceRecoverUtil] recoverFromTraceRecord : ");
        this.recoverInit();
        Global oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != this.engine.getDesktopGlobal();
        try {
            if (globalChanged) {
                Context.setGlobal((Global)this.engine.getDesktopGlobal());
            }
            int i = 0;
            while (i < this.traceRecords.size()) {
                TraceRecord traceRecord = this.traceRecords.get(i);
                System.out.println(traceRecord.toString());
                for (int j = 0; j < traceRecord.length(); ++j) {
                    Trace trace = traceRecord.traces.get(j);
                    if (trace instanceof TraceSetup) {
                        this.recoverSetup((TraceSetup)trace);
                        continue;
                    }
                    if (trace instanceof TraceSet) {
                        this.recoverSet((TraceSet)trace);
                        continue;
                    }
                    if (trace instanceof TraceDone) {
                        ScriptObject.setAllocID((int)((TraceDone)trace).getID());
                        continue;
                    }
                    if (trace instanceof TraceInitArray) {
                        this.recoverInitArray((TraceInitArray)trace);
                        continue;
                    }
                    if (!(trace instanceof TraceInitObject)) continue;
                    this.recoverInitObject((TraceInitObject)trace);
                }
                this.recoverFlag = i++;
            }
        }
        catch (Exception exception) {
        }
        finally {
            Context.setGlobal((Global)oldGlobal);
        }
        return "[recoverFromTraceRecord] recover all";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recoverFromTraceRecord(int c) {
        int oldflag = this.recoverFlag;
        if (this.recoverFlag < 0) {
            this.recoverInit();
        }
        if (this.recoverFlag > c) {
            System.out.println("[recoverFromTraceRecord] recoverFlag now is " + this.recoverFlag + " ,can't recover to " + c + " !");
            return "recover from trace failed!";
        }
        if (c >= this.traceRecords.size()) {
            System.out.println("[recoverFromTraceRecord] traceRecords' size now is " + this.traceRecords.size() + " ,can't recover to " + c + " !");
            return "recover from trace failed!";
        }
        Global oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != this.engine.getDesktopGlobal();
        try {
            if (globalChanged) {
                Context.setGlobal((Global)this.engine.getDesktopGlobal());
            }
            int i = this.recoverFlag + 1;
            while (i <= c) {
                TraceRecord traceRecord = this.traceRecords.get(i);
                for (int j = 0; j < traceRecord.length(); ++j) {
                    Trace trace = traceRecord.traces.get(j);
                    if (trace instanceof TraceSetup) {
                        this.recoverSetup((TraceSetup)trace);
                        continue;
                    }
                    if (trace instanceof TraceSet) {
                        this.recoverSet((TraceSet)trace);
                        continue;
                    }
                    if (trace instanceof TraceDone) {
                        ScriptObject.setAllocID((int)((TraceDone)trace).getID());
                        continue;
                    }
                    if (trace instanceof TraceInitArray) {
                        this.recoverInitArray((TraceInitArray)trace);
                        continue;
                    }
                    if (!(trace instanceof TraceInitObject)) continue;
                    this.recoverInitObject((TraceInitObject)trace);
                }
                this.recoverFlag = i++;
            }
        }
        catch (Exception exception) {
        }
        finally {
            Context.setGlobal((Global)oldGlobal);
        }
        this.recoverFlag = c;
        return "[recoverFromTraceRecord] recover from " + oldflag + " to " + c;
    }

    public void recoverSetup(TraceSetup trace) {
        ScriptObjectMirror obj = null;
        int id = -1;
        if (trace.getObj() instanceof JSArray) {
            id = ((JSArray)trace.getObj()).getObjID();
            obj = (ScriptObjectMirror)ScriptObjectMirror.wrap((Object)Global.allocate((int[])new int[0]), (Object)this.engine.getDesktopGlobal());
            obj.setObjectID(id);
        } else if (trace.getObj() instanceof JSObject) {
            id = ((JSObject)trace.getObj()).getObjID();
            JO so = new JO(JO.getInitialMap());
            so.setObjectID(id);
            obj = (ScriptObjectMirror)ScriptObjectMirror.wrap((Object)so, (Object)this.engine.getDesktopGlobal());
        }
        this.recoverMap.put(id, obj);
    }

    public void recoverInitArray(TraceInitArray trace) {
        for (int i = 0; i < trace.getLength(); ++i) {
            TraceSet trace2 = new TraceSet(trace.getArrayId(), trace.getKey(i), trace.getValue(i));
            this.recoverSet(trace2);
        }
    }

    public void recoverInitObject(TraceInitObject trace) {
        ScriptObject so = this.getScriptObjectMirrorById(trace.getId()).getScriptObject();
        ScriptObject so2 = this.getScriptObjectMirrorById(trace.getId2()).getScriptObject();
        ScriptObject.setGlobalObjectProto((ScriptObject)so2);
    }

    public void recoverSet(TraceSet trace) {
        ScriptObjectMirror owner = this.getScriptObjectMirrorById(trace.getOwner());
        Object key = trace.getKey();
        Object value = trace.getValue();
        if (value instanceof JSObject) {
            value = this.getScriptObjectMirrorById(((JSObject)value).getObjID());
        } else if (value instanceof JSArray) {
            value = this.getScriptObjectMirrorById(((JSArray)value).getObjID());
        } else if (!(value instanceof String || value instanceof Integer || value instanceof Double)) {
            if (value instanceof JSNull) {
                return;
            }
            if (value instanceof JSUndifined) {
                return;
            }
            System.out.println("[recoverSet] encounter new value type!" + value.toString());
        }
        owner.setMember2(key, value);
    }

    private void initRecoverMap(ScriptObjectMirror obj) {
        if (obj == null) {
            return;
        }
        if (this.recoverMap.containsKey(obj.getObjectID())) {
            return;
        }
        this.recoverMap.put(obj.getObjectID(), obj);
        for (String key : obj.getOwnKeys(true)) {
            try {
                Object value = obj.getMember(key);
                if (!(value instanceof ScriptObjectMirror)) continue;
                ScriptObjectMirror svalue = (ScriptObjectMirror)value;
                this.initRecoverMap(svalue);
                if (!svalue.isFunction()) continue;
                ScriptFunction sf = (ScriptFunction)svalue.getScriptObject();
                ScriptObject s = sf.getScope();
                ScriptObjectMirror obj2 = (ScriptObjectMirror)ScriptObjectMirror.wrap((Object)s, (Object)JavaScriptEntry.getEngineGlobal());
                this.initRecoverMap(obj2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ScriptObjectMirror getScriptObjectMirrorById(int id) {
        ScriptObjectMirror so = null;
        if (this.recoverMap.containsKey(id)) {
            return this.recoverMap.get(id);
        }
        System.out.println("[getScriptObjectMirrorById] can't find the ScriptObjectMirror by id!");
        return so;
    }
}

