package org.bdware.sc.engine.hook;

import org.bdware.mockjava.MockUtil;
import org.bdware.sc.JSEngine;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.bean.ProjectConfig;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.node.AnnotationHook;

public class MockTemplateHandler implements AnnotationHook {
    @Override
    public Object handle(ContractRequest request, JSEngine engine, Object ret) {
        try {
            if (request.fromDebug()) {
                System.out.println(request.getAction());
                DesktopEngine desktopEngine = (DesktopEngine) engine;
                ProjectConfig projectConfig = desktopEngine.getProjectConfig();
                String template = projectConfig.getMock(request.getAction());
                if (template != null && template.length() > 0) {
                    System.out.println(template);
                    MockUtil Mock = new MockUtil();
                    return Mock.mock(template).toString();
                } else return ret; //When mock config is null defined just ignore.
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            return ret;
        }
    }
}
