package org.bdware.sc.engine.hook;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.JSEngine;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.bean.ProjectConfig;
import org.bdware.sc.boundry.ScriptReturnException;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.FunctionNode;

@YJSAnnotation(name = "ArgSchema")
public class ArgSchemaHandler implements AnnotationHook {
    private AnnotationNode a;
    private static final Logger LOGGER = LogManager.getLogger(ArgSchemaHandler.class);
    public ArgSchemaHandler(AnnotationNode annoNode){
        a=annoNode;
        String arg = a.getArgs().get(0);

//        if (arg.startsWith("/")){
//            ;//ContractProcess.instance.engine.getResources().loadAsString(arg);
//        }else {
//            ;
//        }
    }
    public  static ArgSchemaHandler fromAnnotationNode(FunctionNode funNode, AnnotationNode annoNode){
        //a= annoNode;
        return new ArgSchemaHandler(annoNode);
    }
    @Override
    public Object handle(ContractRequest input, JSEngine Engine, Object ret) throws ScriptReturnException {
        //input.getArg();
        DesktopEngine desktopEngine = (DesktopEngine) Engine;
        ArgSchemaVisitor visitor = new ArgSchemaVisitor(JsonParser.parseString(input.getArg().getAsString()));


        System.out.println(JsonParser.parseString(input.getArg().getAsString()));
        System.out.println(JsonParser.parseString(a.getArgs().get(0)));

        if(input.getArg().getAsString().isEmpty()&&!a.getArgs().get(0).equals("")){
            JsonObject jo = new JsonObject();
            jo.addProperty("msg", "[Empty argument] argument should not be empty");
            jo.addProperty("code", 1003);
            //jo.add("code":);
            throw new ScriptReturnException(jo);
        }
        visitor.visit(JsonParser.parseString(a.getArgs().get(0)));
        if (!visitor.getStatus()) {
            JsonObject jo = new JsonObject();
            jo.addProperty("msg", visitor.getException());
            jo.addProperty("code", visitor.errorCode);
            //jo.add("code":);
            throw new ScriptReturnException(jo);
        }
        return ret;
    }
}
