/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.statistics.container.communicator;

import com.alibaba.datax.common.statistics.VMInfo;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.statistics.communication.Communication;
import com.alibaba.datax.core.statistics.container.collector.AbstractCollector;
import com.alibaba.datax.core.statistics.container.report.AbstractReporter;
import com.alibaba.datax.dataxservice.face.domain.enums.State;
import java.util.List;
import java.util.Map;

public abstract class AbstractContainerCommunicator {
    private Configuration configuration;
    private AbstractCollector collector;
    private AbstractReporter reporter;
    private Long jobId;
    private VMInfo vmInfo = VMInfo.getVmInfo();
    private long lastReportTime = System.currentTimeMillis();

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public AbstractCollector getCollector() {
        return this.collector;
    }

    public AbstractReporter getReporter() {
        return this.reporter;
    }

    public void setCollector(AbstractCollector collector) {
        this.collector = collector;
    }

    public void setReporter(AbstractReporter reporter) {
        this.reporter = reporter;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public AbstractContainerCommunicator(Configuration configuration) {
        this.configuration = configuration;
        this.jobId = configuration.getLong("core.container.job.id");
    }

    public abstract void registerCommunication(List<Configuration> var1);

    public abstract Communication collect();

    public abstract void report(Communication var1);

    public abstract State collectState();

    public abstract Communication getCommunication(Integer var1);

    public abstract Map<Integer, Communication> getCommunicationMap();

    public void resetCommunication(Integer id) {
        Map<Integer, Communication> map = this.getCommunicationMap();
        map.put(id, new Communication());
    }

    public void reportVmInfo() {
        long now = System.currentTimeMillis();
        if (now - this.lastReportTime >= 300000L) {
            if (this.vmInfo != null) {
                this.vmInfo.getDelta(true);
            }
            this.lastReportTime = now;
        }
    }
}

