/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.transport.exchanger;

import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.TaskPluginCollector;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.core.statistics.communication.Communication;
import com.alibaba.datax.core.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.core.transport.transformer.TransformerExecution;
import com.alibaba.datax.core.util.container.ClassLoaderSwapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransformerExchanger {
    private static final Logger LOG = LoggerFactory.getLogger(TransformerExchanger.class);
    protected final TaskPluginCollector pluginCollector;
    protected final int taskGroupId;
    protected final int taskId;
    protected final Communication currentCommunication;
    private long totalExaustedTime = 0L;
    private long totalFilterRecords = 0L;
    private long totalSuccessRecords = 0L;
    private long totalFailedRecords = 0L;
    private List<TransformerExecution> transformerExecs;
    private ClassLoaderSwapper classLoaderSwapper = ClassLoaderSwapper.newCurrentThreadClassLoaderSwapper();

    public TransformerExchanger(int taskGroupId, int taskId, Communication communication, List<TransformerExecution> transformerExecs, TaskPluginCollector pluginCollector) {
        this.transformerExecs = transformerExecs;
        this.pluginCollector = pluginCollector;
        this.taskGroupId = taskGroupId;
        this.taskId = taskId;
        this.currentCommunication = communication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record doTransformer(Record record) {
        if (this.transformerExecs == null || this.transformerExecs.size() == 0) {
            return record;
        }
        Record result = record;
        long diffExaustedTime = 0L;
        String errorMsg = null;
        boolean failed = false;
        for (TransformerExecution transformerInfoExec : this.transformerExecs) {
            long startTs = System.nanoTime();
            if (transformerInfoExec.getClassLoader() != null) {
                this.classLoaderSwapper.setCurrentThreadClassLoader(transformerInfoExec.getClassLoader());
            }
            if (!transformerInfoExec.isChecked()) {
                if (transformerInfoExec.getColumnIndex() != null && transformerInfoExec.getColumnIndex() >= record.getColumnNumber()) {
                    throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, String.format("columnIndex[%s] out of bound[%s]. name=%s", transformerInfoExec.getColumnIndex(), record.getColumnNumber(), transformerInfoExec.getTransformerName()));
                }
                transformerInfoExec.setIsChecked(true);
            }
            try {
                result = transformerInfoExec.getTransformer().evaluate(result, transformerInfoExec.gettContext(), transformerInfoExec.getFinalParas());
            }
            catch (Exception e) {
                errorMsg = String.format("transformer(%s) has Exception(%s)", transformerInfoExec.getTransformerName(), e.getMessage());
                failed = true;
                break;
            }
            finally {
                if (transformerInfoExec.getClassLoader() != null) {
                    this.classLoaderSwapper.restoreCurrentThreadClassLoader();
                }
            }
            if (result == null) {
                ++this.totalFilterRecords;
                break;
            }
            long diff = System.nanoTime() - startTs;
            diffExaustedTime += diff;
        }
        this.totalExaustedTime += diffExaustedTime;
        if (failed) {
            ++this.totalFailedRecords;
            this.pluginCollector.collectDirtyRecord(record, errorMsg);
            return null;
        }
        ++this.totalSuccessRecords;
        return result;
    }

    public void doStat() {
        this.currentCommunication.setLongCounter("totalTransformerSuccessRecords", this.totalSuccessRecords);
        this.currentCommunication.setLongCounter("totalTransformerFailedRecords", this.totalFailedRecords);
        this.currentCommunication.setLongCounter("totalTransformerFilterRecords", this.totalFilterRecords);
        this.currentCommunication.setLongCounter("totalTransformerUsedTime", this.totalExaustedTime);
    }
}

