/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.reader.util;

import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.plugin.rdbms.reader.Constant;
import com.alibaba.datax.plugin.rdbms.reader.util.ReaderSplitUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtil;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HintUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderSplitUtil.class);
    private static DataBaseType dataBaseType;
    private static String username;
    private static String password;
    private static Pattern tablePattern;
    private static String hintExpression;

    public static void initHintConf(DataBaseType type, Configuration configuration) {
        dataBaseType = type;
        username = configuration.getString("username");
        password = configuration.getString("password");
        String hint = configuration.getString("hint");
        if (StringUtils.isNotBlank((CharSequence)hint)) {
            String[] tablePatternAndHint = hint.split("#");
            if (tablePatternAndHint.length == 1) {
                tablePattern = Pattern.compile(".*");
                hintExpression = tablePatternAndHint[0];
            } else {
                tablePattern = Pattern.compile(tablePatternAndHint[0]);
                hintExpression = tablePatternAndHint[1];
            }
        }
    }

    public static String buildQueryColumn(String jdbcUrl, String table, String column) {
        block3: {
            try {
                Matcher m;
                if (tablePattern == null || !DataBaseType.Oracle.equals((Object)dataBaseType) || !(m = tablePattern.matcher(table)).find()) break block3;
                String[] tableStr = table.split("\\.");
                String tableWithoutSchema = tableStr[tableStr.length - 1];
                String finalHint = hintExpression.replaceAll(Constant.TABLE_NAME_PLACEHOLDER, tableWithoutSchema);
                if (finalHint.indexOf("parallel") > 0 && DBUtil.isOracleMaster(jdbcUrl, username, password)) {
                    LOG.info("master:{} will not use hint:{}", (Object)jdbcUrl, (Object)finalHint);
                    break block3;
                }
                LOG.info("table:{} use hint:{}.", (Object)table, (Object)finalHint);
                return finalHint + column;
            }
            catch (Exception e) {
                LOG.warn("match hint exception, will not use hint", (Throwable)e);
            }
        }
        return column;
    }
}

