/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.debugger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.client.SmartContractClient;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.bean.Contract;
import org.bdware.sc.bean.ContractExecType;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.get.GetMessage;
import org.bdware.sc.http.HttpUtil;
import org.bdware.sc.util.FileUtil;
import org.bdware.sc.util.JsonUtil;
import org.zz.gmhelper.SM2KeyPair;

public class DebugMain {
    static Logger LOGGER = LogManager.getLogger(DebugMain.class);

    public static void runWithConf(String configPath) {
        String content = FileUtil.getFileContent((String)configPath);
        DebugConfig config = (DebugConfig)JsonUtil.fromJson((String)content, DebugConfig.class);
        DebugMain.inject(config);
        String keyPairStr = "{\"publicKey\":\"%s\",\"privateKey\":\"%s\"}";
        SM2KeyPair pair = SM2KeyPair.fromJson((String)String.format(keyPairStr, config.publicKey, config.privateKey));
        String uriFormat = "ws://%s/SCIDE/SCExecutor";
        if (config.killBeforeStart != null && config.killBeforeStart.length() > 0) {
            final AtomicInteger counter = new AtomicInteger(0);
            SmartContractClient client = new SmartContractClient(String.format(uriFormat, config.agentAddress), pair){

                public void onLogin(JsonObject obj) {
                    counter.incrementAndGet();
                }

                public void onKillContractProcess(JsonObject obj) {
                    counter.incrementAndGet();
                }
            };
            client.waitForConnect();
            client.login();
            try {
                while (counter.get() == 0) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            client.sendMsg("{\"action\":\"killContractProcess\",\"name\":\"" + config.killBeforeStart + "\"}");
            try {
                while (counter.get() == 1) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        config.contract.setCreateParam(config.createParam);
        ContractProcess.main(new String[]{"-port=" + config.port, "-cmi=" + config.cmi, "-disablePID"});
        ResultCallback printCallback = new ResultCallback(){

            public void onResult(String str) {
                LOGGER.info(str);
            }
        };
        ContractProcess.instance.handler.setDBInfo(DebugMain.wrap("", config.dbPath), printCallback);
        ContractProcess.instance.handler.registerMangerPort(DebugMain.wrap("", config.cPort), printCallback);
        ContractProcess.instance.handler.setContractBundle(DebugMain.wrap("", config.contract), printCallback);
        String urlFormat = "http://%s/SCIDE/SCManager?action=reconnectPort&owner=%s&port=%d";
        String url = String.format(urlFormat, config.agentAddress, config.publicKey, ContractProcess.instance.server.mainPort.get());
        Map resp = HttpUtil.httpGet((String)url);
        String data = (String)resp.get("response");
        LOGGER.info("start done!");
    }

    public static void main(String[] args) {
        DebugMain.runWithConf("./debugconf.json");
    }

    private static void inject(DebugConfig config) {
        Contract contract;
        String urlFormat = "http://%s/SCIDE/SCManager?action=%s&arg=%s";
        String url = String.format(urlFormat, config.agentAddress, "getAgentConfig", "");
        Map resp = HttpUtil.httpGet((String)url);
        String data = (String)resp.get("response");
        JsonObject jsonObject = JsonUtil.parseStringAsJsonObject((String)data);
        config.cmi = jsonObject.get("cmi").getAsString();
        config.dbPath = jsonObject.get("dbPath").getAsString();
        config.cPort = jsonObject.get("cPort").getAsInt();
        config.port = jsonObject.get("port").getAsInt();
        JsonObject ownerAndScript = new JsonObject();
        String arg = "abc&owner=" + config.publicKey + "&script=" + config.ypkPath;
        url = String.format(urlFormat, config.agentAddress, "allocateKeyPair", arg);
        resp = HttpUtil.httpGet((String)url);
        LOGGER.info(url);
        String contractStr = (String)resp.get("response");
        LOGGER.info("[ContratStr] " + contractStr);
        config.contract = contract = (Contract)JsonUtil.fromJson((String)contractStr, Contract.class);
        contract.setType(ContractExecType.Sole);
    }

    private static GetMessage wrap(String operation, Object arg) {
        return DebugMain.wrap(operation, JsonUtil.toJson((Object)arg));
    }

    private static GetMessage wrap(String operation, String arg) {
        GetMessage msg = new GetMessage();
        msg.method = operation;
        msg.arg = arg;
        return msg;
    }

    static class DebugConfig {
        String agentAddress;
        public JsonElement createParam;
        String publicKey;
        String privateKey;
        String killBeforeStart;
        String ypkPath;
        int port;
        String cmi;
        String dbPath;
        int cPort;
        Contract contract;

        DebugConfig() {
        }
    }
}

