/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.boundry;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bdware.sc.engine.YJSClassLoader;

public class Resources {
    private final ZipFile zf;
    YJSClassLoader loader;

    public Resources(ZipFile zf, YJSClassLoader loader) {
        this.zf = zf;
        this.loader = loader;
    }

    public InputStream loadAsInputStream(String path) {
        try {
            ZipEntry entry = this.zf.getEntry(path);
            if (entry == null) {
                return null;
            }
            return this.zf.getInputStream(entry);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Scanner loadAsScanner(String path) {
        try {
            ZipEntry entry = this.zf.getEntry(path);
            if (entry == null) {
                return null;
            }
            return new Scanner(this.zf.getInputStream(entry));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String loadAsString(String path) {
        try {
            InputStream sc = this.loadAsInputStream(path);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            int k = 0;
            while ((k = sc.read(buff)) > 0) {
                bo.write(buff, 0, k);
            }
            return new String(bo.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<?> testloadAsScanner(String path) {
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            ZipEntry entry = this.zf.getEntry(path);
            if (entry == null) {
                return null;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.zf.getInputStream(entry), StandardCharsets.UTF_8));
            String line = null;
            while ((line = reader.readLine()) != null) {
                fileList.add(line);
            }
            return fileList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String unzipToDir(String path) {
        ZipEntry entry = this.zf.getEntry(path);
        try {
            return this.loader.unzipLibrary(this.zf.getInputStream(entry), entry.getName().replaceAll(".*/", ""));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

