/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.statistics.plugin.task;

import com.alibaba.datax.common.constant.PluginType;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.TaskPluginCollector;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.statistics.communication.Communication;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskPluginCollector
extends TaskPluginCollector {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTaskPluginCollector.class);
    private Communication communication;
    private Configuration configuration;
    private PluginType pluginType;

    public AbstractTaskPluginCollector(Configuration conf, Communication communication, PluginType type) {
        this.configuration = conf;
        this.communication = communication;
        this.pluginType = type;
    }

    public Communication getCommunication() {
        return this.communication;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public PluginType getPluginType() {
        return this.pluginType;
    }

    @Override
    public final void collectMessage(String key, String value) {
        this.communication.addMessage(key, value);
    }

    @Override
    public void collectDirtyRecord(Record dirtyRecord, Throwable t, String errorMessage) {
        if (null == dirtyRecord) {
            LOG.warn("\u810f\u6570\u636erecord=null.");
            return;
        }
        if (this.pluginType.equals((Object)PluginType.READER)) {
            this.communication.increaseCounter("readFailedRecords", 1L);
            this.communication.increaseCounter("readFailedBytes", dirtyRecord.getByteSize());
        } else if (this.pluginType.equals((Object)PluginType.WRITER)) {
            this.communication.increaseCounter("writeFailedRecords", 1L);
            this.communication.increaseCounter("writeFailedBytes", dirtyRecord.getByteSize());
        } else {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, String.format("\u4e0d\u77e5\u9053\u7684\u63d2\u4ef6\u7c7b\u578b[%s].", new Object[]{this.pluginType}));
        }
    }
}

