/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import com.alibaba.datax.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.maskingMethods.irreversibleInterference.MD5EncryptionImpl;
import java.util.Arrays;

public class MD5Transformer
extends Transformer {
    private Object masker;
    String key;
    int columnIndex;

    public MD5Transformer() {
        this.setTransformerName("dx_md5");
        System.out.println("Using MD5 preserve masker");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        try {
            if (paras.length < 1) {
                throw new RuntimeException("dx_md5 transformer\u7f3a\u5c11\u53c2\u6570");
            }
            this.columnIndex = (Integer)paras[0];
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(this.columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                return record;
            }
            if (column.getType() == Column.Type.STRING) {
                MD5EncryptionImpl masker = new MD5EncryptionImpl();
                String newValue = masker.execute(oriValue);
                record.setColumn(this.columnIndex, new StringColumn(newValue));
            }
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }
}

