/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.bdware.mockjava.JsonVisitor;
import org.paillier.PaillierCipher;

public class HomoVisitor
extends JsonVisitor {
    public static RSAPublicKey publicKey;
    JsonElement root;
    public static RSAPrivateKey privateKey;

    public HomoVisitor(JsonElement ret) {
        this.root = ret;
    }

    public JsonVisitor visitObject(JsonObject homoConfig) {
        if (this.root.isJsonObject()) {
            JsonObject jo = this.root.getAsJsonObject();
            for (String key : homoConfig.keySet()) {
                if (!jo.has(key)) continue;
                HomoVisitor visitor = new HomoVisitor(jo.get(key));
                visitor.visit(homoConfig.get(key));
                jo.add(key, visitor.get());
            }
        }
        return this;
    }

    public JsonVisitor visitJsonArray(JsonArray ele) {
        if (this.root.isJsonArray()) {
            JsonArray array = this.root.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                HomoVisitor visitor = new HomoVisitor(array.get(i));
                visitor.visit(ele.get(0));
                array.set(i, visitor.get());
            }
        }
        return this;
    }

    public JsonElement get() {
        return this.root;
    }

    public JsonVisitor visitPrimitive(JsonPrimitive primitive) {
        if (primitive.isString()) {
            String method = primitive.getAsString();
            try {
                String result = "";
                if (method.equals("@encrypt")) {
                    BigInteger i = this.handleRoot(this.root.getAsString());
                    result = PaillierCipher.encrypt((BigInteger)i, (PublicKey)publicKey);
                } else if (method.equals("@decrypt")) {
                    BigInteger i = PaillierCipher.decrypt((String)this.root.getAsString(), (PrivateKey)privateKey);
                    result = String.valueOf(i);
                } else {
                    result = this.root.getAsString();
                }
                System.out.println(result);
                this.root = new JsonPrimitive(result);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return this;
    }

    private BigInteger handleRoot(String data) {
        double d = Double.parseDouble(data);
        long l = (long)d;
        return BigInteger.valueOf(l);
    }
}

