/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.container.util;

import com.alibaba.datax.common.exception.CommonErrorCode;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.spi.Hook;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import com.alibaba.datax.core.util.container.JarLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HookInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(HookInvoker.class);
    private final Map<String, Number> msg;
    private final Configuration conf;
    private File baseDir;

    public HookInvoker(String baseDirName, Configuration conf, Map<String, Number> msg) {
        this.baseDir = new File(baseDirName);
        this.conf = conf;
        this.msg = msg;
    }

    public void invokeAll() {
        if (!this.baseDir.exists() || this.baseDir.isFile()) {
            LOG.info("No hook invoked, because base dir not exists or is a file: " + this.baseDir.getAbsolutePath());
            return;
        }
        String[] subDirs = this.baseDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory();
            }
        });
        if (subDirs == null) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.HOOK_LOAD_ERROR, "\u83b7\u53d6HOOK\u5b50\u76ee\u5f55\u8fd4\u56denull");
        }
        for (String subDir : subDirs) {
            this.doInvoke(new File(this.baseDir, subDir).getAbsolutePath());
        }
    }

    private void doInvoke(String path) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            JarLoader jarLoader = new JarLoader(new String[]{path});
            Thread.currentThread().setContextClassLoader(jarLoader);
            Iterator<Hook> hookIt = ServiceLoader.load(Hook.class).iterator();
            if (!hookIt.hasNext()) {
                LOG.warn("No hook defined under path: " + path);
            } else {
                Hook hook = hookIt.next();
                LOG.info("Invoke hook [{}], path: {}", (Object)hook.getName(), (Object)path);
                hook.invoke(this.conf, this.msg);
            }
        }
        catch (Exception e) {
            LOG.error("Exception when invoke hook", (Throwable)e);
            throw DataXException.asDataXException(CommonErrorCode.HOOK_INTERNAL_ERROR, "Exception when invoke hook", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public static void main(String[] args) {
        new HookInvoker("/Users/xiafei/workspace/datax3/target/datax/datax/hook", null, new HashMap<String, Number>()).invokeAll();
    }
}

