/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.bdware.mockjava.JsonVisitor;

public class ArgSchemaVisitor
extends JsonVisitor {
    JsonElement root;
    public boolean status = true;
    public int errorCode = 0;
    public String message = "";

    public ArgSchemaVisitor(JsonElement ret) {
        this.root = ret;
    }

    public JsonVisitor visitObject(JsonObject schema) {
        if (this.root.isJsonObject()) {
            JsonObject jo = this.root.getAsJsonObject();
            for (String key : schema.keySet()) {
                ArgSchemaVisitor visitor;
                if (key.startsWith("!")) {
                    if (jo.has(key.substring(1))) {
                        visitor = new ArgSchemaVisitor(jo.get(key.substring(1)));
                        visitor.visit(schema.get(key));
                        jo.add(key, visitor.get());
                        if (!visitor.status) {
                            this.errorCode += visitor.errorCode;
                            this.message = this.message + visitor.message;
                        }
                        this.status &= visitor.status;
                        continue;
                    }
                    this.message = this.message + "[Missing argument] " + key.substring(1) + " should be supplied ";
                    this.status = false;
                    this.errorCode = 1002;
                    continue;
                }
                if (!jo.has(key)) continue;
                visitor = new ArgSchemaVisitor(jo.get(key));
                visitor.visit(schema.get(key));
                jo.add(key, visitor.get());
                if (!visitor.status) {
                    this.message = this.message + visitor.message;
                    this.errorCode += visitor.errorCode;
                }
                this.status &= visitor.status;
            }
        } else {
            this.message = this.message + "[Incorrect type] should be object";
            this.status = false;
            this.errorCode = 1003;
        }
        return this;
    }

    public JsonVisitor visitJsonArray(JsonArray ele) {
        if (this.root.isJsonArray()) {
            JsonArray array = this.root.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                ArgSchemaVisitor visitor = new ArgSchemaVisitor(array.get(i));
                visitor.visit(ele.get(0));
                this.message = this.message + visitor.message;
            }
        }
        return this;
    }

    public JsonElement get() {
        return this.root;
    }

    public JsonVisitor visitPrimitive(JsonPrimitive primitive) {
        if (primitive.isString()) {
            String type = primitive.getAsString();
            try {
                String result = "";
                if (type.equals("string")) {
                    if (this.root.isJsonPrimitive() && this.root.getAsJsonPrimitive().isString()) {
                        return this;
                    }
                    this.message = "[Type error] The value (" + this.root.getAsJsonPrimitive().getAsString() + ") should be string";
                    this.status = false;
                    this.errorCode = 1001;
                    return this;
                }
                if (type.equals("number")) {
                    if (this.root.isJsonPrimitive() && this.root.getAsJsonPrimitive().isNumber()) {
                        return this;
                    }
                    this.message = "[Type error] The value (" + this.root.getAsJsonPrimitive().getAsString() + ") should be number";
                    this.status = false;
                    this.errorCode = 1001;
                    return this;
                }
                if (type.equals("boolean")) {
                    if (this.root.isJsonPrimitive() && this.root.getAsJsonPrimitive().isBoolean()) {
                        return this;
                    }
                    this.message = "[Type error] The value (" + this.root.getAsJsonPrimitive().getAsString() + ") should be boolean";
                    this.status = false;
                    this.errorCode = 1001;
                    return this;
                }
                if (type.equals("[]")) {
                    if (this.root.isJsonArray()) {
                        return this;
                    }
                    this.message = "[Type error] The value (" + this.root.getAsJsonPrimitive().getAsString() + ") should be array";
                    this.status = false;
                    this.errorCode = 1001;
                    return this;
                }
                if (type.equals("{}")) {
                    if (this.root.isJsonObject()) {
                        return this;
                    }
                    this.message = "[Type error] The value (" + this.root.getAsJsonPrimitive().getAsString() + ") should be object";
                    this.status = false;
                    this.errorCode = 1001;
                    return this;
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return this;
    }

    public boolean getStatus() {
        return this.status;
    }

    public String getException() {
        return this.message;
    }
}

