/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.util;

import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TableExpandUtil {
    public static Pattern pattern = Pattern.compile("(\\w+\\.)?(\\w+)\\[(\\d+)-(\\d+)\\](.*)");

    private TableExpandUtil() {
    }

    public static List<String> splitTables(DataBaseType dataBaseType, String tables) {
        ArrayList<String> splittedTables = new ArrayList<String>();
        String[] tableArrays = tables.split(",");
        String tableName = null;
        for (String tableArray : tableArrays) {
            Matcher matcher = pattern.matcher(tableArray.trim());
            if (!matcher.matches()) {
                tableName = tableArray.trim();
                splittedTables.add(tableName);
                continue;
            }
            String start = matcher.group(3).trim();
            String end = matcher.group(4).trim();
            String tmp = "";
            if (Integer.valueOf(start) > Integer.valueOf(end)) {
                tmp = start;
                start = end;
                end = tmp;
            }
            int len = start.length();
            String schema = null;
            for (int k = Integer.valueOf(start).intValue(); k <= Integer.valueOf(end); ++k) {
                String string = schema = null == matcher.group(1) ? "" : matcher.group(1).trim();
                if (start.startsWith("0")) {
                    tableName = schema + matcher.group(2).trim() + String.format("%0" + len + "d", k) + matcher.group(5).trim();
                    splittedTables.add(tableName);
                    continue;
                }
                tableName = schema + matcher.group(2).trim() + String.format("%d", k) + matcher.group(5).trim();
                splittedTables.add(tableName);
            }
        }
        return splittedTables;
    }

    public static List<String> expandTableConf(DataBaseType dataBaseType, List<String> tables) {
        ArrayList<String> parsedTables = new ArrayList<String>();
        for (String table : tables) {
            List<String> splittedTables = TableExpandUtil.splitTables(dataBaseType, table);
            parsedTables.addAll(splittedTables);
        }
        return parsedTables;
    }
}

