/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.memory.MemoryDumpUtil;
import org.bdware.sc.memory.MemoryRecoverUtil;
import org.bdware.sc.redo.TransRecordUtil;
import org.bdware.sc.redo.TransRecoverUtil;
import org.bdware.sc.syncMech.SyncRecord;
import org.bdware.sc.syncMech.SyncType;
import org.bdware.sc.trace.TraceRecordUtil;

public class SyncMechUtil {
    private static final Logger LOGGER = LogManager.getLogger(SyncMechUtil.class);
    public AtomicInteger filedTrans;
    public Boolean startFlag = false;
    public List<SyncRecord> syncRecords;
    public SyncType currType;
    public MemoryDumpUtil memoryDumpUtil;
    public MemoryRecoverUtil memoryRecoverUtil;
    public TraceRecordUtil traceRecordUtil;
    public TransRecordUtil transRecordUtil;
    public TransRecoverUtil transRecoverUtil;
    public DesktopEngine engine;
    public String contractID;
    public String syncFileName;
    public String dir;
    public String memoryDir;
    public String traceDir;
    public String transDir;
    public String syncDir;
    public String crDir;

    public SyncMechUtil(DesktopEngine en) {
        this.engine = en;
    }

    public void setDir(String str) {
        this.dir = str;
        String[] strs = str.split("/");
        this.contractID = strs[strs.length - 1];
        this.setMemoryDir(this.dir + "memory");
        this.setTraceDir(this.dir + "trace");
        this.setTransDir(this.dir + "trans");
        this.setSyncDir(this.dir + "sync");
        this.setCrDir(this.dir + "cr");
    }

    public void setMemoryDir(String dir) {
        this.memoryDir = dir;
        File f = new File(this.memoryDir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public void setTraceDir(String dir) {
        this.traceDir = dir;
        File f = new File(this.traceDir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public void setTransDir(String dir) {
        this.transDir = dir;
        File f = new File(this.transDir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public void setSyncDir(String dir) {
        this.syncDir = dir;
        File f = new File(this.syncDir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public void setCrDir(String dir) {
        this.crDir = dir;
        File f = new File(this.crDir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public void clearAllFiles() {
        this.cleanDirectory(this.syncDir);
        this.cleanDirectory(this.crDir);
        this.cleanDirectory(this.memoryDir);
        this.cleanDirectory(this.traceDir);
        this.cleanDirectory(this.transDir);
    }

    private void cleanDirectory(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            String[] children;
            for (String child : children = file.list()) {
                File temp = new File(file, child);
                temp.delete();
            }
        }
    }

    public synchronized String dumpMemory(String path) {
        if (this.memoryDumpUtil == null) {
            this.memoryDumpUtil = new MemoryDumpUtil(this.engine.engine);
        }
        return this.memoryDumpUtil.dumpMemory(path, true);
    }

    public synchronized String dumpMemory(String path, boolean stateful) {
        LOGGER.info("dumpMemroy : stateful=" + stateful);
        if (this.memoryDumpUtil == null) {
            this.memoryDumpUtil = new MemoryDumpUtil(this.engine.engine);
        }
        return this.memoryDumpUtil.dumpMemory(path, stateful);
    }

    public synchronized String loadMemoryDump(String path) {
        if (this.memoryRecoverUtil == null) {
            this.memoryRecoverUtil = new MemoryRecoverUtil(this.engine.engine, this.engine.resources);
        }
        this.memoryRecoverUtil.loadMemory(path, true);
        return "success";
    }

    public synchronized String loadMemoryDump(String path, boolean stateful) {
        LOGGER.info("loadMemroy : stateful=" + stateful);
        if (this.memoryRecoverUtil == null) {
            this.memoryRecoverUtil = new MemoryRecoverUtil(this.engine.engine, this.engine.resources);
        }
        this.memoryRecoverUtil.loadMemory(path, stateful);
        return "success";
    }

    public void setCRFile(String fileName) {
        this.syncFileName = fileName.substring(15);
        File file = new File(this.syncDir + "/" + this.syncFileName);
        try {
            FileWriter fw = new FileWriter(file, true);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(fileName);
            pw.flush();
            fw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartFlag(boolean b) {
        Boolean bl = this.startFlag;
        synchronized (bl) {
            if (this.startFlag == b && !b) {
                return;
            }
            this.startFlag = b;
            if (this.startFlag.booleanValue()) {
                this.filedTrans = new AtomicInteger(-1);
                this.syncRecords = new ArrayList<SyncRecord>();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH_mm_ss");
                String path = format.format(new Date()) + "_" + new Random().nextInt();
                String state = this.dumpMemory(this.memoryDir + "/" + path);
                this.syncRecords.add(new SyncRecord(SyncType.Memory, path));
                this.changeCurrType(SyncType.Trans);
                path = format.format(new Date()) + "_" + new Random().nextInt();
                this.transRecordUtil.setFileName(path);
                this.syncRecords.add(new SyncRecord(SyncType.Trans, path));
                this.appendSyncFile(this.syncFileName, 0, 1);
            } else {
                this.clearAllFiles();
            }
        }
    }

    public void changeCurrType(SyncType t) {
        if (t == this.currType) {
            return;
        }
        this.currType = t;
        switch (this.currType) {
            case Trace: {
                if (this.traceRecordUtil != null) break;
                this.traceRecordUtil = new TraceRecordUtil(this.engine, this);
                break;
            }
            case Trans: {
                if (this.transRecordUtil != null) break;
                this.transRecordUtil = new TransRecordUtil(this.engine, this);
                break;
            }
            case Memory: {
                if (this.memoryDumpUtil != null) break;
                this.memoryDumpUtil = new MemoryDumpUtil(this.engine.engine);
                break;
            }
        }
    }

    public void appendSyncFile(String fileName, int start, int end) {
        File file = new File(this.syncDir + "/" + fileName);
        try {
            FileWriter fw = new FileWriter(file, true);
            PrintWriter pw = new PrintWriter(fw);
            for (int i = start; i <= end; ++i) {
                pw.println(this.syncRecords.get(i).getContent());
            }
            pw.flush();
            fw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized String redo(String path) {
        File file;
        if (this.transRecoverUtil == null) {
            this.transRecoverUtil = new TransRecoverUtil(this.engine);
        }
        if (this.transRecoverUtil.transRecords != null && !this.transRecoverUtil.transRecords.isEmpty()) {
            this.transRecoverUtil.transRecords.clear();
        }
        if (!(file = new File(path)).exists()) {
            return "success";
        }
        this.transRecoverUtil.setTraceRecords(path);
        this.transRecoverUtil.recoverFromTransRecord();
        return "success";
    }
}

