/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.memory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.script.Bindings;
import org.bdware.sc.boundry.JavaScriptEntry;
import org.bdware.sc.memory.JSEDump;
import org.bdware.sc.memory.MemoryDump;
import org.bdware.sc.memory.MemoryJSObject;
import org.bdware.sc.util.JsonUtil;
import wrp.jdk.nashorn.api.scripting.NashornScriptEngine;

public class MemoryDumpUtil {
    public static final String STATELESS_MEMORY = "statelessContractMemory";
    public static AtomicInteger checkPointCounter;
    NashornScriptEngine engine;
    String dumpContent;
    MemoryDump memoryDump = null;

    public MemoryDumpUtil(NashornScriptEngine en) {
        this.engine = en;
    }

    public static String getContentFromFile(String path) {
        File file = new File(path);
        try {
            FileInputStream fileout = new FileInputStream(file);
            GZIPInputStream gzin = new GZIPInputStream(fileout);
            ObjectInputStream reader = new ObjectInputStream(gzin);
            MemoryDump memoryDump = new MemoryDump();
            memoryDump = (MemoryDump)reader.readObject();
            reader.close();
            String ret = JsonUtil.toPrettyJson(memoryDump.objects);
            ret = ret + "<seperate>" + memoryDump.jseDump.invokeID + ";" + memoryDump.jseDump.ranSeed + ";" + memoryDump.jseDump.numsOfCopies + "";
            return ret;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpMemory(String path, boolean stateful) {
        NashornScriptEngine nashornScriptEngine = this.engine;
        synchronized (nashornScriptEngine) {
            String ret;
            this.memoryDump = new MemoryDump();
            if (stateful) {
                Bindings bindings = this.engine.getBindings(100);
                MemoryJSObject root = this.memoryDump.getRoot();
                for (String key : bindings.keySet()) {
                    Object obj = bindings.get(key);
                    long id = this.memoryDump.allocate(obj);
                    root.addField(key, id);
                }
                this.memoryDump.jseDump = new JSEDump(JavaScriptEntry.invokeID, Long.parseLong(JavaScriptEntry.currentSyncUtil.contractID), JavaScriptEntry.numOfCopies);
                ret = JsonUtil.toPrettyJson(this.memoryDump.objects);
            } else {
                this.memoryDump.jseDump = new JSEDump(JavaScriptEntry.invokeID, Long.parseLong(JavaScriptEntry.currentSyncUtil.contractID), JavaScriptEntry.numOfCopies);
                this.memoryDump.objects.clear();
                ret = JsonUtil.toPrettyJson(this.memoryDump.objects);
            }
            ret = ret + "--seperate--";
            ret = ret + this.memoryDump.jseDump.invokeID + ";" + this.memoryDump.jseDump.ranSeed + ";" + this.memoryDump.jseDump.numsOfCopies;
            if (path == null || path.equals("")) {
                return ret;
            }
            File mem = new File(path);
            File parent = mem.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try {
                FileOutputStream fileout = new FileOutputStream(mem);
                GZIPOutputStream out = new GZIPOutputStream(fileout);
                ObjectOutputStream writer = new ObjectOutputStream(out);
                writer.writeObject(this.memoryDump);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.memoryDump = null;
            return ret;
        }
    }
}

