package org.bdware.sc.compiler.ap;

import org.bdware.sc.bean.DoipOperationInfo;
import org.bdware.sc.compiler.AnnotationProcessor;
import org.bdware.sc.engine.hook.DOOPHandler;
import org.bdware.sc.handler.DOOPRequestHandler;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.ContractNode;
import org.bdware.sc.node.FunctionNode;


// DOOP is designed for DoipModule which contains specific functions for RepositoryHandler
public class DOOP extends AnnotationProcessor {
    @Override
    public void processFunction(AnnotationNode anno, ContractNode contractNode, FunctionNode functionNode) {
        // 通过DOOP注解，解析对应的值，并放进对应的FunctionNode中
        // 注解必须暴露出来昂！！！
        functionNode.setIsExport(true);
        functionNode.setIsDoipOperation(true);
        functionNode.setDoipOperationInfo(DoipOperationInfo.create(anno, contractNode));
        // functionNode.setFunctionName(functionNode.getDoipOperationInfo().operationName);

        // 维护DOOPRequestHandler
        DOOPRequestHandler.createHandler();
        DOOPRequestHandler.instance.addDoipOperation(functionNode);

        // 维护DOOPHandler
        DOOPHandler.createDOOPHandler();
        DOOPHandler.instance.putFuncNameAndDoipOperationsMapping(functionNode);

        // 维护ContractNode，functionName is useless, use BasicOperation to map the corresponding functionNode
        // contractNode.updateFunctionMap(functionNode.functionName, functionNode.getDoipOperationInfo().operationName);
    }
}
