/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core;

import com.alibaba.datax.common.element.ColumnCast;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.statistics.PerfTrace;
import com.alibaba.datax.common.statistics.VMInfo;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.AbstractContainer;
import com.alibaba.datax.core.job.JobContainer;
import com.alibaba.datax.core.taskgroup.TaskGroupContainer;
import com.alibaba.datax.core.util.ConfigParser;
import com.alibaba.datax.core.util.ConfigurationValidate;
import com.alibaba.datax.core.util.ExceptionTracker;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import com.alibaba.datax.core.util.container.LoadUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine {
    private static final Logger LOG = LoggerFactory.getLogger(Engine.class);
    private static String RUNTIME_MODE;

    public void start(Configuration allConf) {
        long instanceId;
        AbstractContainer container;
        ColumnCast.bind(allConf);
        LoadUtil.bind(allConf);
        boolean isJob = !"taskGroup".equalsIgnoreCase(allConf.getString("core.container.model"));
        int channelNumber = 0;
        int taskGroupId = -1;
        if (isJob) {
            allConf.set("core.container.job.mode", RUNTIME_MODE);
            container = new JobContainer(allConf);
            instanceId = allConf.getLong("core.container.job.id", 0L);
        } else {
            container = new TaskGroupContainer(allConf);
            instanceId = allConf.getLong("core.container.job.id");
            taskGroupId = allConf.getInt("core.container.taskGroup.id");
            channelNumber = allConf.getInt("core.container.taskGroup.channel");
        }
        boolean traceEnable = allConf.getBool("core.container.trace.enable", true);
        boolean perfReportEnable = allConf.getBool("core.dataXServer.reportPerfLog", true);
        if (instanceId == -1L) {
            perfReportEnable = false;
        }
        int priority = 0;
        try {
            priority = Integer.parseInt(System.getenv("SKYNET_PRIORITY"));
        }
        catch (NumberFormatException e) {
            LOG.warn("prioriy set to 0, because NumberFormatException, the value is: " + System.getProperty("PROIORY"));
        }
        Configuration jobInfoConfig = allConf.getConfiguration("job.jobInfo");
        PerfTrace perfTrace = PerfTrace.getInstance(isJob, instanceId, taskGroupId, priority, traceEnable);
        perfTrace.setJobInfo(jobInfoConfig, perfReportEnable, channelNumber);
        container.start();
    }

    public static String filterJobConfiguration(Configuration configuration) {
        Configuration jobConfWithSetting = configuration.getConfiguration("job").clone();
        Configuration jobContent = jobConfWithSetting.getConfiguration("content");
        Engine.filterSensitiveConfiguration(jobContent);
        jobConfWithSetting.set("content", jobContent);
        return jobConfWithSetting.beautify();
    }

    public static Configuration filterSensitiveConfiguration(Configuration configuration) {
        Set<String> keys = configuration.getKeys();
        for (String key : keys) {
            boolean isSensitive = StringUtils.endsWithIgnoreCase((CharSequence)key, (CharSequence)"password") || StringUtils.endsWithIgnoreCase((CharSequence)key, (CharSequence)"accessKey");
            if (!isSensitive || !(configuration.get(key) instanceof String)) continue;
            configuration.set(key, configuration.getString(key).replaceAll(".", "*"));
        }
        return configuration;
    }

    public static void entry(String[] args) throws Throwable {
        long jobId;
        Options options = new Options();
        options.addOption("job", true, "Job config.");
        options.addOption("jobid", true, "Job unique id.");
        options.addOption("mode", true, "Job runtime mode.");
        BasicParser parser = new BasicParser();
        CommandLine cl = parser.parse(options, args);
        String jobPath = cl.getOptionValue("job");
        String jobIdString = cl.getOptionValue("jobid");
        RUNTIME_MODE = cl.getOptionValue("mode");
        Configuration configuration = ConfigParser.parse(jobPath);
        if (!"-1".equalsIgnoreCase(jobIdString)) {
            jobId = Long.parseLong(jobIdString);
        } else {
            String dscJobUrlPatternString = "/instance/(\\d{1,})/config.xml";
            String dsJobUrlPatternString = "/inner/job/(\\d{1,})/config";
            String dsTaskGroupUrlPatternString = "/inner/job/(\\d{1,})/taskGroup/";
            List<String> patternStringList = Arrays.asList(dscJobUrlPatternString, dsJobUrlPatternString, dsTaskGroupUrlPatternString);
            jobId = Engine.parseJobIdFromUrl(patternStringList, jobPath);
        }
        boolean isStandAloneMode = "standalone".equalsIgnoreCase(RUNTIME_MODE);
        if (!isStandAloneMode && jobId == -1L) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.CONFIG_ERROR, "\u975e standalone \u6a21\u5f0f\u5fc5\u987b\u5728 URL \u4e2d\u63d0\u4f9b\u6709\u6548\u7684 jobId.");
        }
        configuration.set("core.container.job.id", jobId);
        VMInfo vmInfo = VMInfo.getVmInfo();
        if (vmInfo != null) {
            LOG.info(vmInfo.toString());
        }
        LOG.info("\n" + Engine.filterJobConfiguration(configuration) + "\n");
        LOG.debug(configuration.toJSON());
        ConfigurationValidate.doValidate(configuration);
        Engine engine = new Engine();
        engine.start(configuration);
    }

    private static long parseJobIdFromUrl(List<String> patternStringList, String url) {
        long result = -1L;
        for (String patternString : patternStringList) {
            result = Engine.doParseJobIdFromUrl(patternString, url);
            if (result == -1L) continue;
            return result;
        }
        return result;
    }

    private static long doParseJobIdFromUrl(String patternString, String url) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            return Long.parseLong(matcher.group(1));
        }
        return -1L;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = 0;
        try {
            Engine.entry(args);
        }
        catch (Throwable e) {
            DataXException tempException;
            ErrorCode errorCode;
            exitCode = 1;
            LOG.error("\n\n\u7ecfDataX\u667a\u80fd\u5206\u6790,\u8be5\u4efb\u52a1\u6700\u53ef\u80fd\u7684\u9519\u8bef\u539f\u56e0\u662f:\n" + ExceptionTracker.trace(e));
            if (e instanceof DataXException && (errorCode = (tempException = (DataXException)e).getErrorCode()) instanceof FrameworkErrorCode) {
                FrameworkErrorCode tempErrorCode = (FrameworkErrorCode)errorCode;
                exitCode = tempErrorCode.toExitValue();
            }
            System.exit(exitCode);
        }
        System.exit(exitCode);
    }
}

