/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.transport.transformer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.core.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import java.util.Arrays;

public class SubstrTransformer
extends Transformer {
    public SubstrTransformer() {
        this.setTransformerName("dx_substr");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        int length;
        int startIndex;
        int columnIndex;
        try {
            if (paras.length != 3) {
                throw new RuntimeException("dx_substr paras must be 3");
            }
            columnIndex = (Integer)paras[0];
            startIndex = Integer.valueOf((String)paras[1]);
            length = Integer.valueOf((String)paras[2]);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                return record;
            }
            if (startIndex > oriValue.length()) {
                throw new RuntimeException(String.format("dx_substr startIndex(%s) out of range(%s)", startIndex, oriValue.length()));
            }
            String newValue = startIndex + length >= oriValue.length() ? oriValue.substring(startIndex, oriValue.length()) : oriValue.substring(startIndex, startIndex + length);
            record.setColumn(columnIndex, new StringColumn(newValue));
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }
}

