/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer;

import com.alibaba.datax.common.element.BoolColumn;
import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.DateColumn;
import com.alibaba.datax.common.element.DoubleColumn;
import com.alibaba.datax.common.element.LongColumn;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import com.alibaba.datax.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.maskingMethods.anonymity.Hiding;
import java.util.Arrays;
import java.util.Date;

public class HidingTransformer
extends Transformer {
    private Object masker;
    String maskMethodId = "";
    String key;
    int columnIndex;

    public HidingTransformer() {
        this.setTransformerName("dx_hiding");
        System.out.println("Using hiding method.");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        try {
            if (paras.length < 1) {
                throw new RuntimeException("Hiding transformer \u7f3a\u5c11\u53c2\u6570");
            }
            this.columnIndex = (Integer)paras[0];
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(this.columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                return record;
            }
            Hiding masker = new Hiding();
            if (column.getType() == Column.Type.STRING) {
                String newValue = masker.mask(column.asString());
                record.setColumn(this.columnIndex, new StringColumn(newValue));
            } else if (column.getType() == Column.Type.DATE) {
                Date newValue = masker.mask(column.asDate());
                record.setColumn(this.columnIndex, new DateColumn(newValue));
            } else if (column.getType() == Column.Type.LONG || column.getType() == Column.Type.INT) {
                long newValue = masker.mask(column.asLong());
                record.setColumn(this.columnIndex, new LongColumn(newValue));
            } else if (column.getType() == Column.Type.BOOL) {
                boolean newValue = masker.mask(column.asBoolean());
                record.setColumn(this.columnIndex, new BoolColumn(newValue));
            } else if (column.getType() == Column.Type.DOUBLE) {
                double newValue = masker.mask(column.asDouble());
                record.setColumn(this.columnIndex, new DoubleColumn(newValue));
            }
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }
}

